/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockPineapple;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public class FeaturePineapplePlant
extends Feature<NoFeatureConfig> {
    public FeaturePineapplePlant() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
        if (WorldGenerator.isBlacklisted((IWorldGenerationReader)world, (List)Configuration.GENERATOR.DIM_BLACKLIST.plants.get())) {
            return false;
        }
        if (position.func_177956_o() < 1 || position.func_177956_o() + 1 > world.getMaxHeight()) {
            return false;
        }
        BlockPineapple pineapple = (BlockPineapple)Values.blockPlants.get((Object)PlantAPI.PlantType.PINEAPPLE);
        if (!FeaturePineapplePlant.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b(), pineapple)) {
            return false;
        }
        if (random.nextBoolean()) {
            this.func_202278_a((IWorldWriter)world, position, (BlockState)pineapple.func_176223_P().func_206870_a(BlockPineapple.VARIANT, (Comparable)((Object)BlockPineapple.EnumType.SMALL)));
        } else if (random.nextBoolean()) {
            this.func_202278_a((IWorldWriter)world, position, (BlockState)pineapple.func_176223_P().func_206870_a(BlockPineapple.VARIANT, (Comparable)((Object)BlockPineapple.EnumType.LARGE)));
        } else {
            this.func_202278_a((IWorldWriter)world, position, (BlockState)pineapple.func_176223_P().func_206870_a(BlockPineapple.VARIANT, (Comparable)((Object)BlockPineapple.EnumType.LARGE_STEM)));
            this.func_202278_a((IWorldWriter)world, position.func_177984_a(), (BlockState)pineapple.func_176223_P().func_206870_a(BlockPineapple.VARIANT, (Comparable)((Object)BlockPineapple.EnumType.FRUIT)));
        }
        return false;
    }

    protected static boolean isSoil(IWorldGenerationBaseReader world, BlockPos pos, IPlantable plantable) {
        if (!(world instanceof IBlockReader) || plantable == null) {
            return world.func_217375_a(pos, state -> {
                Block block = state.func_177230_c();
                return Block.func_196245_f((Block)block) || block == Blocks.field_196658_i;
            });
        }
        return world.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)world, pos, Direction.UP, plantable));
    }
}

