/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.client.gui.Textures;

public class EnderTableRecipeWrapper {
    private final ResourceLocation bookshelf = new ResourceLocation("minecraft", "textures/block/bookshelf.png");
    private final ItemStack result;
    private final List<List<ItemStack>> inputs;
    private final int expCost;
    private final int matCost;
    private final float ePower;

    EnderTableRecipeWrapper(ItemStack result, ItemStack[] inputEnchant, ItemStack[] inputMaterial, int expCost, int matCost, float ePower) {
        this.result = result;
        this.inputs = new ArrayList<List<ItemStack>>();
        this.inputs.add(this.process(inputEnchant, 1));
        this.inputs.add(this.process(inputMaterial, matCost));
        this.expCost = expCost;
        this.matCost = matCost;
        this.ePower = ePower;
    }

    private List<ItemStack> process(ItemStack[] input, int size) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            stack = stack.func_77946_l();
            stack.func_190920_e(size);
            list.add(stack);
        }
        return list;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.result);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, double mouseX, double mouseY) {
        FontRenderer font = minecraft.field_71466_p;
        String power = " @ " + (int)Math.ceil(this.ePower) + "x ";
        int half = font.func_78256_a(power) / 2;
        GuiFunctions.enterDrawTextureStateWithBlend();
        minecraft.func_110434_K().func_110577_a(this.bookshelf);
        GuiFunctions.drawTextureScaled((double)(45 + half), (double)24.0, (int)0, (int)0, (int)16, (int)16, (double)0.5, (float)1.0f, (int[])new int[]{16});
        minecraft.func_110434_K().func_110577_a(Textures.ENDERTABLE.get());
        GuiFunctions.drawTexture((double)(45 - half - 14), (double)24.0, (int)125, (int)0, (int)14, (int)8, (float)0.5f, (int[])new int[0]);
        GuiFunctions.exitDrawTextureStateWithBlend();
        font.func_211126_b(power, (float)(45 - half), 25.0f, 0x8B8B8B);
        String exp = "" + this.expCost;
        font.func_175063_a(exp, (float)(54 - font.func_78256_a(exp)), 14.0f, 8453920);
    }

    public List<String> getTooltipStrings(double mouseX, double mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        if (mouseX >= 36.0 && mouseX <= 54.0 && mouseY >= 4.0 && mouseY <= 22.0) {
            list.add(Localization.get((String)"info.terraqueous.exp.txt"));
        } else if (mouseX >= 15.0 && mouseX <= 75.0 && mouseY >= 24.0 && mouseY <= 32.0) {
            float ePower = (float)Math.ceil(this.ePower * 100.0f) / 100.0f;
            list.add(Localization.get((String)"info.terraqueous.visible.txt").replace("%1$s", "" + ePower));
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnderTableRecipeWrapper)) {
            return false;
        }
        EnderTableRecipeWrapper other = (EnderTableRecipeWrapper)obj;
        if (other.result != this.result || other.expCost != this.expCost || other.matCost != this.matCost || other.inputs.size() != this.inputs.size()) {
            return false;
        }
        List<ItemStack> tEnchant = this.inputs.get(0);
        List<ItemStack> oEnchant = other.inputs.get(0);
        if (tEnchant.size() != oEnchant.size()) {
            return false;
        }
        for (int index = 0; index < tEnchant.size(); ++index) {
            if (ItemStack.func_77989_b((ItemStack)tEnchant.get(index), (ItemStack)oEnchant.get(index))) continue;
            return false;
        }
        List<ItemStack> tMaterials = this.inputs.get(1);
        List<ItemStack> oMaterials = other.inputs.get(1);
        if (tMaterials.size() != oMaterials.size()) {
            return false;
        }
        for (int index = 0; index < tMaterials.size(); ++index) {
            if (ItemStack.func_77989_b((ItemStack)tMaterials.get(index), (ItemStack)oMaterials.get(index))) continue;
            return false;
        }
        return true;
    }
}

