/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.power;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;

public class ForgeUnits {
    public static void init() {
        if ((Double)Configuration.STORMFORGE.powerMultiplierFU.get() > 0.0) {
            StormForgeRegistry.register(new RechargeHandler());
        }
    }

    public static class RechargeHandler
    implements IStormForgeRechargeHandler {
        @Override
        public boolean handleStack(ItemStack stack) {
            return !stack.func_190926_b() && stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent();
        }

        @Override
        public boolean charge(ItemStack stack, double amount, boolean outright) {
            if (!stack.func_190926_b()) {
                LazyOptional storage = stack.getCapability(CapabilityEnergy.ENERGY, null);
                AtomicBoolean charge = new AtomicBoolean(true);
                storage.ifPresent(handler -> charge.set(handler.receiveEnergy(outright ? Integer.MAX_VALUE : (int)amount, false) > 0));
                return charge.get();
            }
            return false;
        }

        @Override
        public boolean isFull(ItemStack stack) {
            if (!stack.func_190926_b()) {
                LazyOptional storage = stack.getCapability(CapabilityEnergy.ENERGY, null);
                AtomicBoolean isFull = new AtomicBoolean(true);
                storage.ifPresent(handler -> isFull.set(handler.getEnergyStored() >= handler.getMaxEnergyStored()));
                return isFull.get();
            }
            return true;
        }

        @Override
        public double multiplier() {
            return (Double)Configuration.STORMFORGE.powerMultiplierFU.get();
        }
    }
}

