/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.terraheads.BlockMobHead;
import shetiphian.terraheads.client.RenderItemMobHead;

public class ItemMobHead
extends SkullItem {
    private final BlockMobHead.Type type;

    public ItemMobHead(BlockMobHead.Type type, Block floorBlock, Block wallBlock, Item.Properties builder) {
        super(floorBlock, wallBlock, builder.setISTER(() -> ItemMobHead::getISTER));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ItemStackTileEntityRenderer getISTER() {
        return RenderItemMobHead.INSTANCE;
    }

    public BlockMobHead.Type getType() {
        return this.type;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            switch (this.type) {
                case VILLAGER: 
                case ZOMBIE_VILLAGER: {
                    Set villages = Registry.field_218369_K.func_148742_b();
                    Set professions = ForgeRegistries.PROFESSIONS.getKeys();
                    for (ResourceLocation village : villages) {
                        for (ResourceLocation entry : professions) {
                            items.add((Object)ItemMobHead.create(new ItemStack((IItemProvider)this), village.toString(), entry.toString()));
                        }
                    }
                    break;
                }
                case ILLAGER: {
                    items.add((Object)ItemMobHead.create(new ItemStack((IItemProvider)this), "evoker"));
                    items.add((Object)ItemMobHead.create(new ItemStack((IItemProvider)this), "illusioner"));
                    items.add((Object)ItemMobHead.create(new ItemStack((IItemProvider)this), "pillager"));
                    items.add((Object)ItemMobHead.create(new ItemStack((IItemProvider)this), "vindicator"));
                    break;
                }
                default: {
                    items.add((Object)new ItemStack((IItemProvider)this));
                }
            }
        }
    }

    public static ItemStack create(ItemStack stack, String ... data) {
        if (!stack.func_190926_b() && data.length > 0) {
            CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
            int index = 0;
            for (String entry : data) {
                ++index;
                if (Strings.isNullOrEmpty((String)entry)) continue;
                nbt.func_74778_a("data" + index, entry);
            }
        }
        return stack;
    }

    public static String getData1(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        return nbt.func_74764_b("data1") ? nbt.func_74779_i("data1") : "";
    }

    public static String getData2(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        return nbt.func_74764_b("data2") ? nbt.func_74779_i("data2") : "";
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String data1 = ItemMobHead.getData1(stack);
        String data2 = ItemMobHead.getData2(stack);
        String name = null;
        switch (this.type) {
            case VILLAGER: 
            case ZOMBIE_VILLAGER: {
                name = this.type == BlockMobHead.Type.ZOMBIE_VILLAGER ? new TranslationTextComponent("entity.minecraft.zombie").getString() + " " : "";
                if (!Strings.isNullOrEmpty((String)data1)) {
                    String villageKey = !data1.contains(":") ? "biome.minecraft." + data1 : "biome." + data1.replace(":", ".");
                    name = name + new TranslationTextComponent(villageKey).getString() + " ";
                }
                if (!Strings.isNullOrEmpty((String)data2)) {
                    data2 = data2.startsWith("minecraft:") ? data2.substring(10) : data2.replace(":", ".");
                    name = name + new TranslationTextComponent("entity.minecraft.villager." + data2).getString();
                    break;
                }
                name = name + new TranslationTextComponent("entity.minecraft.villager").getString();
                break;
            }
            case ILLAGER: {
                if (Strings.isNullOrEmpty((String)data1)) break;
                name = new TranslationTextComponent("entity.minecraft." + data1).getString();
                break;
            }
            default: {
                String key = "entity.minecraft." + this.type.toString();
                name = new TranslationTextComponent(key).getString();
                if (!name.equals(key)) break;
                name = null;
            }
        }
        if (name != null) {
            return new TranslationTextComponent("block.minecraft.player_head.named", new Object[]{name});
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
    }
}

