/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads.client;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import shetiphian.terraheads.BlockMobHead;
import shetiphian.terraheads.TileEntityMobHead;
import shetiphian.terraheads.client.ModelVillagerHead;
import shetiphian.terraheads.client.ModelWitchHead;

@OnlyIn(value=Dist.CLIENT)
public class RenderMobHead
extends TileEntityRenderer<TileEntityMobHead>
implements ISelectiveResourceReloadListener {
    public static RenderMobHead INSTANCE;
    public static ItemStack ENTITY_EQUIPPED;
    private static final Table<String, String, ResourceLocation> TEXTURE_CACHE;
    private static final Map<ResourceLocation, VillagerMetadataSection.HatType> HAT_CACHE;
    private static final ModelVillagerHead MODEL_VILLAGER;
    private static final ModelWitchHead MODEL_WITCH;

    public RenderMobHead(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)INSTANCE);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.MODELS) || predicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            TEXTURE_CACHE.clear();
            HAT_CACHE.clear();
        }
    }

    public void render(TileEntityMobHead tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        float animation = 0.0f;
        BlockState blockstate = tile.func_195044_w();
        boolean isWall = blockstate.func_177230_c() instanceof WallSkullBlock;
        Direction direction = isWall ? (Direction)blockstate.func_177229_b((Property)WallSkullBlock.field_196302_a) : null;
        float rotation = 22.5f * (float)(isWall ? (2 + direction.func_176736_b()) * 4 : (Integer)blockstate.func_177229_b((Property)SkullBlock.field_196294_a));
        this.render(direction, rotation, ((BlockMobHead.MobHead)blockstate.func_177230_c()).getType(), animation, tile.getData1(), tile.getData2(), matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public void render(Direction facing, float rotation, BlockMobHead.Type type, float animation, String data1, String data2, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        AxisAlignedBB aabb = type.getShapeGround().func_197752_a();
        matrixStack.func_227861_a_(aabb.field_72336_d - aabb.field_72340_a, 0.0, aabb.field_72334_f - aabb.field_72339_c);
        if (facing != null) {
            double height = (1.0 - (aabb.field_72337_e - aabb.field_72338_b)) / 2.0;
            switch (facing) {
                case NORTH: {
                    matrixStack.func_227861_a_(0.0, height, aabb.field_72339_c);
                    break;
                }
                case SOUTH: {
                    matrixStack.func_227861_a_(0.0, height, -aabb.field_72339_c);
                    break;
                }
                case WEST: {
                    matrixStack.func_227861_a_(aabb.field_72340_a, height, 0.0);
                    break;
                }
                default: {
                    matrixStack.func_227861_a_(-aabb.field_72340_a, height, 0.0);
                }
            }
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        switch (type) {
            case VILLAGER: {
                this.renderVillagerHead(rotation, "villager", data1, data2, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case ZOMBIE_VILLAGER: {
                this.renderVillagerHead(rotation, "zombie_villager", data1, data2, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case ILLAGER: {
                this.renderVillagerHead(rotation, "illager", !Strings.isNullOrEmpty((String)data1) ? data1 : "pillager", matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case WANDERING_TRADER: {
                this.renderVillagerHead(rotation, "", "wandering_trader", matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case WITCH: {
                this.renderWitchHead(rotation, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
        matrixStack.func_227865_b_();
    }

    private void renderVillagerHead(float rotation, String folder, String type, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        MODEL_VILLAGER.renderWithHood(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, folder, type), combinedLight, combinedOverlay);
    }

    private void renderVillagerHead(float rotation, String folder, String type, String profession, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        boolean renderTypeHat;
        MODEL_VILLAGER.renderBase(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, folder, folder), combinedLight, combinedOverlay);
        ResourceLocation texType = this.getTexture(folder + "/type", type);
        ResourceLocation texProfession = this.getTexture(folder + "/profession", Strings.isNullOrEmpty((String)profession) || profession.endsWith("none") ? "" : profession);
        VillagerMetadataSection.HatType tHat = this.getHatType(texType);
        VillagerMetadataSection.HatType pHat = this.getHatType(texProfession);
        boolean bl = renderTypeHat = pHat == VillagerMetadataSection.HatType.NONE || pHat == VillagerMetadataSection.HatType.PARTIAL && tHat != VillagerMetadataSection.HatType.FULL;
        if (renderTypeHat && texType != MissingTextureSprite.func_195675_b()) {
            MODEL_VILLAGER.renderOverlay(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, texType), combinedLight, combinedOverlay);
        }
        if (texProfession != MissingTextureSprite.func_195675_b()) {
            MODEL_VILLAGER.renderOverlay(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, texProfession), combinedLight, combinedOverlay);
        }
    }

    private VillagerMetadataSection.HatType getHatType(ResourceLocation location) {
        if (location != null && location != MissingTextureSprite.func_195675_b()) {
            if (!HAT_CACHE.containsKey(location)) {
                VillagerMetadataSection.HatType type = VillagerMetadataSection.HatType.NONE;
                try (IResource iresource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);){
                    VillagerMetadataSection villagermetadatasection = (VillagerMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (villagermetadatasection != null) {
                        type = villagermetadatasection.func_217826_a();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                HAT_CACHE.put(location, type);
            }
            return HAT_CACHE.get(location);
        }
        return VillagerMetadataSection.HatType.NONE;
    }

    private void renderWitchHead(float rotation, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        MODEL_WITCH.render(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, "", "witch"), combinedLight, combinedOverlay);
    }

    private IVertexBuilder getVertexBuilder(IRenderTypeBuffer buffer, String subFolder, String file) {
        return this.getVertexBuilder(buffer, this.getTexture(subFolder, file));
    }

    private IVertexBuilder getVertexBuilder(IRenderTypeBuffer buffer, ResourceLocation texture) {
        return buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture));
    }

    private ResourceLocation getTexture(String subFolder, String file) {
        if (!Strings.isNullOrEmpty((String)file)) {
            if (Strings.isNullOrEmpty((String)subFolder)) {
                subFolder = "|";
            }
            if (!TEXTURE_CACHE.contains((Object)subFolder, (Object)file)) {
                int i = file.indexOf(":");
                String modId = i > 0 ? file.substring(0, i) : "minecraft";
                String name = i > 0 ? file.substring(i + 1) : file;
                ResourceLocation location = new ResourceLocation(modId, "textures/entity/" + (subFolder.equals("|") ? "" : subFolder + "/") + name + ".png");
                TEXTURE_CACHE.put((Object)subFolder, (Object)file, (Object)location);
            }
            return (ResourceLocation)TEXTURE_CACHE.get((Object)subFolder, (Object)file);
        }
        return MissingTextureSprite.func_195675_b();
    }

    static {
        ENTITY_EQUIPPED = ItemStack.field_190927_a;
        TEXTURE_CACHE = HashBasedTable.create();
        HAT_CACHE = new HashMap<ResourceLocation, VillagerMetadataSection.HatType>();
        MODEL_VILLAGER = new ModelVillagerHead();
        MODEL_WITCH = new ModelWitchHead();
    }
}

