/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import shetiphian.terraqueous.api.cloud.ICloud;

public class CloudAPI {
    public static final BooleanProperty KICKABLE = BooleanProperty.func_177716_a((String)"generated");
    public static final Material materialCloud = new Material(MaterialColor.field_151660_b, false, true, false, false, false, false, PushReaction.DESTROY);
    public static SoundType soundTypeCloud = new SoundType(1.0f, -5.0f, SoundEvents.field_187807_fF, SoundEvents.field_187815_fJ, SoundEvents.field_187813_fI, SoundEvents.field_187811_fH, SoundEvents.field_187809_fG);
    private static final HashMap<String, Boolean> CLOUD_BLOCKS = new HashMap();
    private static final HashSet<String> CLOUD_WALK_ITEMS = new HashSet();
    public static final ITag.INamedTag<Item> TAG_CLOUD_WALK = ItemTags.func_199901_a((String)"terraqueous:status/cloud_walk");
    private static final HashMap<UUID, HashSet<String>> CLOUD_WALKING_ENTITIES = new HashMap();

    public static void addCloudBlock(Block block, boolean punchable) {
        if (block != null) {
            CloudAPI.addCloudBlock(block.getRegistryName().toString(), punchable);
        }
    }

    public static void addCloudBlock(String key, boolean punchable) {
        if (!Strings.isNullOrEmpty((String)key)) {
            CLOUD_BLOCKS.put(key, punchable);
        }
    }

    public static void addCloudWalkItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CloudAPI.addCloudWalkItem(stack.func_77973_b().getRegistryName().toString());
        }
    }

    public static void addCloudWalkItem(String key) {
        if (!Strings.isNullOrEmpty((String)key)) {
            CLOUD_WALK_ITEMS.add(key);
        }
    }

    public static void grantCloudWalk(LivingEntity entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.func_110124_au()).add(source.toLowerCase().trim());
        }
    }

    public static void revokeCloudWalk(LivingEntity entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.func_110124_au()).remove(source.toLowerCase().trim());
        }
    }

    public static boolean hasCloudWalk(LivingEntity entity) {
        if (entity != null) {
            return !CloudAPI.getOrCreate(entity.func_110124_au()).isEmpty();
        }
        return false;
    }

    private static Set<String> getOrCreate(UUID uuid) {
        if (!CLOUD_WALKING_ENTITIES.containsKey(uuid)) {
            CLOUD_WALKING_ENTITIES.put(uuid, new HashSet());
        }
        return CLOUD_WALKING_ENTITIES.get(uuid);
    }

    public static boolean entityCanBeOnClouds(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75101_c) {
                return true;
            }
        }
        return entity != null && CloudAPI.hasCloudWalk(entity);
    }

    public static boolean isCloud(BlockState state, IBlockReader world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudBlock(state, world, pos);
        }
        return CloudAPI.isCloud(state);
    }

    public static boolean isCloud(BlockState state) {
        if (state.func_185904_a() == materialCloud) {
            return true;
        }
        ResourceLocation id = state.func_177230_c().getRegistryName();
        return id != null && CLOUD_BLOCKS.containsKey(id);
    }

    public static boolean isCloudWalkItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return TAG_CLOUD_WALK.func_230235_a_((Object)stack.func_77973_b()) || CLOUD_WALK_ITEMS.contains(stack.func_77973_b().getRegistryName().toString());
        }
        return false;
    }

    public static boolean isCloudKickable(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudKickable(state, (IBlockReader)world, pos);
        }
        boolean kickable = false;
        try {
            kickable = (Boolean)state.func_177229_b((Property)KICKABLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return kickable || CloudAPI.isCloudKickable(state.func_177230_c());
    }

    public static boolean isCloudKickable(Block block) {
        ResourceLocation id = block.getRegistryName();
        return id != null && CLOUD_BLOCKS.containsKey(id) && CLOUD_BLOCKS.get(id) != false;
    }

    public static boolean getKickable(BlockState state) {
        boolean kickable;
        try {
            kickable = (Boolean)state.func_177229_b((Property)KICKABLE);
        }
        catch (Exception e) {
            kickable = false;
        }
        return kickable;
    }

    public static enum CloudType implements IStringSerializable
    {
        LIGHT(0, MaterialColor.field_197655_T),
        DENSE(1, MaterialColor.field_193568_T),
        STORM(2, MaterialColor.field_193560_ab);

        private static final CloudType[] array;
        private final byte id;
        private final MaterialColor color;

        private CloudType(int id, MaterialColor color) {
            this.id = (byte)id;
            this.color = color;
        }

        public byte getID() {
            return this.id;
        }

        public static CloudType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public MaterialColor getColor() {
            return this.color;
        }

        static {
            array = new CloudType[]{LIGHT, DENSE, STORM};
        }
    }
}

