/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import shetiphian.terraqueous.api.cloud.CloudAPI;

public class CloudPresets {
    public static AbstractBlock.Properties properties() {
        return CloudPresets.properties(AbstractBlock.Properties.func_200945_a((Material)CloudAPI.materialCloud));
    }

    public static AbstractBlock.Properties properties(MaterialColor color) {
        return CloudPresets.properties(AbstractBlock.Properties.func_200949_a((Material)CloudAPI.materialCloud, (MaterialColor)color));
    }

    public static AbstractBlock.Properties properties(AbstractBlock.Properties properties) {
        return properties.func_200947_a(CloudAPI.soundTypeCloud).func_200948_a(0.7f, 0.5f).harvestTool(ToolType.SHOVEL).harvestLevel(0).func_235842_b_((state, world, pos) -> false).func_235847_c_((state, world, pos) -> false);
    }

    public static boolean isFlammable() {
        return false;
    }

    public static PushReaction getPushReaction() {
        return PushReaction.DESTROY;
    }

    public static boolean isFoliage() {
        return true;
    }

    public static boolean shouldCollide(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return entity instanceof LivingEntity && CloudAPI.entityCanBeOnClouds((LivingEntity)entity);
    }

    public static void onEntityWalking(World world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.02, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        }
    }

    public static void onEntityCollision(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            CloudPresets.hitCloud(state, world, pos, entity);
            if (!CloudAPI.entityCanBeOnClouds((LivingEntity)entity)) {
                Vector3d motion = entity.func_213322_ci();
                if (entity instanceof PlayerEntity) {
                    entity.func_213293_j(motion.field_72450_a, 0.0, motion.field_72449_c);
                } else {
                    entity.func_213295_a(Blocks.field_196553_aF.func_176223_P(), new Vector3d(0.25, (double)0.05f, 0.25));
                    entity.func_213293_j(motion.field_72450_a, -2.0, motion.field_72449_c);
                }
            }
        }
    }

    public static void onFallenUpon(World world, BlockPos pos, Entity entity, float fallDistance) {
        BlockState state = world.func_180495_p(pos);
        CloudPresets.hitCloud(state, world, pos, entity);
        CloudPresets.onEntityWalking(world, pos, entity);
    }

    private static void hitCloud(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity.field_70143_R >= 3.0f && !world.field_72995_K) {
            entity.field_70143_R = 0.0f;
        }
    }
}

