/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import com.google.gson.JsonElement;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class SimpleEnderTableRecipe
implements IEnderTableRecipe {
    protected final Ingredient enchant;
    protected final Ingredient material;
    protected final ItemStack output;
    protected final int expCost;
    protected final int matCost;
    protected final float ePower;
    protected final String tooltip;
    protected final boolean obfuscate;

    public SimpleEnderTableRecipe(ItemStack result, Object inputEnchant, Object inputMaterial, int materialCost, int experienceCost, float enchantPower, String tooltip, boolean obfuscate) {
        this.output = result.func_77946_l();
        this.enchant = this.processInput(inputEnchant);
        this.material = this.processInput(inputMaterial);
        this.matCost = materialCost;
        this.expCost = Math.max(0, experienceCost);
        this.ePower = enchantPower;
        this.tooltip = tooltip;
        this.obfuscate = obfuscate;
        if (this.enchant == Ingredient.field_193370_a || this.material == Ingredient.field_193370_a && inputMaterial != null) {
            String ret = "Invalid simple EnderTable recipe: " + inputEnchant + ", " + inputMaterial + ", " + this.output;
            throw new RuntimeException(ret);
        }
    }

    private Ingredient processInput(Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)obj).func_77946_l()});
        }
        if (obj instanceof Item) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(Item)obj});
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)((Block)obj))});
        }
        if (obj instanceof String) {
            return Ingredient.func_199805_a((ITag)ItemTags.func_199901_a((String)((String)obj)));
        }
        if (obj instanceof ResourceLocation) {
            return Ingredient.func_199805_a((ITag)ItemTags.func_199901_a((String)((ResourceLocation)obj).toString()));
        }
        if (obj instanceof ITag.INamedTag) {
            return Ingredient.func_199805_a((ITag)((ITag.INamedTag)obj));
        }
        if (obj instanceof JsonElement) {
            return CraftingHelper.getIngredient((JsonElement)((JsonElement)obj));
        }
        return Ingredient.field_193370_a;
    }

    @Override
    public boolean matches(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        return enchantPower >= this.ePower && option == IEnderTableRecipe.EnumOption.SECOND && this.checkMatch(this.enchant, enchantStack, false) && this.checkMatch(this.material, materialStack, true);
    }

    private boolean checkMatch(Ingredient target, ItemStack tableItem, boolean checksize) {
        if (target == Ingredient.field_193370_a) {
            return tableItem.func_190926_b();
        }
        if (checksize && (tableItem.func_190926_b() || tableItem.func_190916_E() < this.matCost)) {
            return false;
        }
        return target.test(tableItem);
    }

    @Override
    public Pair<Ingredient, Ingredient> getInput(IEnderTableRecipe.EnumOption option) {
        if (option == IEnderTableRecipe.EnumOption.SECOND) {
            return Pair.of((Object)this.enchant, (Object)this.material);
        }
        return Pair.of((Object)Ingredient.field_193370_a, (Object)Ingredient.field_193370_a);
    }

    @Override
    @Nonnull
    public ItemStack getResult(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.output.func_77946_l() : ItemStack.field_190927_a;
    }

    @Override
    public int getExpCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.expCost : 0;
    }

    @Override
    public int getMaterialCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.matCost : 0;
    }

    @Override
    public float getEPower(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.ePower : 0.0f;
    }

    @Override
    public String getTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.tooltip;
    }

    @Override
    public boolean obfuscateTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.obfuscate;
    }

    @Override
    public void doneEnchant(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
    }
}

