/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.inventory.ContainerEnderTable;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnderTable
extends ContainerScreen<ContainerEnderTable> {
    private static final ResourceLocation TEXTURE_BOOK = new ResourceLocation("terraqueous", "textures/entity/enderbook.png");
    private static final ItemStack STACK_ENDER_DUST = new ItemStack((IItemProvider)Values.itemEnderDust);
    public static final ITag.INamedTag<Item> TAG_MONOCLE = ItemTags.func_199901_a((String)"terraqueous:status/ender_sight");
    private static final BookModel MODEL_BOOK = new BookModel();
    private final Random random = new Random();
    public int ticks;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookRotation;
    public float bookRotationPrev;
    ItemStack enchantStack;

    public GuiEnderTable(ContainerEnderTable screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.field_146999_f = 182;
        this.field_147000_g = 171;
        this.enchantStack = ItemStack.field_190927_a;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ItemStack stack = ((ContainerEnderTable)this.field_147002_h).func_75139_a(0).func_75211_c();
        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.enchantStack)) {
            this.enchantStack = stack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.pageFlip <= this.flipT + 1.0f && this.pageFlip >= this.flipT - 1.0f);
        }
        ++this.ticks;
        this.pageFlipPrev = this.pageFlip;
        this.bookRotationPrev = this.bookRotation;
        boolean flag = false;
        for (int index = 0; index < 3; ++index) {
            if (((ContainerEnderTable)this.field_147002_h).experienceCost[index] == 0) continue;
            flag = true;
            break;
        }
        this.bookRotation = flag ? (this.bookRotation += 0.2f) : (this.bookRotation -= 0.2f);
        this.bookRotation = MathHelper.func_76131_a((float)this.bookRotation, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.pageFlip) * 0.4f;
        float f = 0.2f;
        f1 = MathHelper.func_76131_a((float)f1, (float)(-f), (float)f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        Minecraft minecraft = Minecraft.func_71410_x();
        for (int index = 0; index < 3; ++index) {
            if (!this.isMouseOverButton(index, mouseX, mouseY) || !((ContainerEnderTable)this.field_147002_h).func_75140_a((PlayerEntity)minecraft.field_71439_g, index)) continue;
            minecraft.field_71442_b.func_78756_a(((ContainerEnderTable)this.field_147002_h).field_75152_c, index);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private void setTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.ENDERTABLE.get());
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.func_227783_c_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setTexture();
        int winX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int winY = (this.field_230709_l_ - this.field_147000_g) / 2;
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.func_238474_b_(matrixStack, winX, winY, 0, 85, 182, 73);
        this.func_238474_b_(matrixStack, winX, winY + 73, 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        int scaleFactor = (int)this.getMinecraft().func_228018_at_().func_198100_s();
        RenderSystem.viewport((int)((this.field_230708_k_ - 320) / 2 * scaleFactor), (int)((this.field_230709_l_ - 240) / 2 * scaleFactor), (int)(320 * scaleFactor), (int)(240 * scaleFactor));
        RenderSystem.translatef((float)-0.34f, (float)0.23f, (float)0.0f);
        RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        RenderSystem.matrixMode((int)5888);
        matrixStack.func_227860_a_();
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        entry.func_227870_a_().func_226591_a_();
        entry.func_227872_b_().func_226119_c_();
        matrixStack.func_227861_a_(0.0, (double)4.3f, 1984.0);
        matrixStack.func_227862_a_(5.0f, 5.0f, 5.0f);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)this.bookRotationPrev, (float)this.bookRotation);
        matrixStack.func_227861_a_((double)((1.0f - f1) * 0.2f), (double)((1.0f - f1) * 0.1f), (double)((1.0f - f1) * 0.25f));
        float f2 = -(1.0f - f1) * 90.0f - 90.0f;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f2));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        float f3 = MathHelper.func_219799_g((float)partialTicks, (float)this.pageFlipPrev, (float)this.pageFlip) + 0.25f;
        float f4 = MathHelper.func_219799_g((float)partialTicks, (float)this.pageFlipPrev, (float)this.pageFlip) + 0.75f;
        f3 = MathHelper.func_76131_a((float)((f3 - (float)MathHelper.func_76140_b((double)f3)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        f4 = MathHelper.func_76131_a((float)((f4 - (float)MathHelper.func_76140_b((double)f4)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        MODEL_BOOK.func_228247_a_(0.0f, f3, f4, f1);
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(MODEL_BOOK.func_228282_a_(TEXTURE_BOOK));
        MODEL_BOOK.func_225598_a_(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        renderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.viewport((int)0, (int)0, (int)this.field_230706_i_.func_228018_at_().func_198109_k(), (int)this.field_230706_i_.func_228018_at_().func_198091_l());
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderHelper.func_227784_d_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnchantmentNameParts.func_178176_a().func_148335_a((long)((ContainerEnderTable)this.field_147002_h).func_217005_f());
        for (int index = 0; index < 3; ++index) {
            int bX = winX + 66;
            int bY = winY + 8;
            this.func_230926_e_(0);
            this.setTexture();
            int expCost = ((ContainerEnderTable)this.field_147002_h).experienceCost[index];
            int matCost = ((ContainerEnderTable)this.field_147002_h).materialCost[index];
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (expCost == 0) {
                this.func_238474_b_(matrixStack, bX, bY + 19 * index, 0, 19, 108, 19);
                continue;
            }
            int[] color = new int[]{6839882, 8453920, 8453920};
            boolean hasExp = this.field_230706_i_.field_71439_g.field_71068_ca >= expCost;
            boolean hasMat = ((ContainerEnderTable)this.field_147002_h).hasMaterialNeeded(index);
            if (!(hasMat && hasExp || this.field_230706_i_.field_71439_g.field_71075_bZ.field_75098_d)) {
                this.func_238474_b_(matrixStack, bX, bY + 19 * index, 0, 19, 108, 19);
                this.func_238474_b_(matrixStack, bX + 90, bY + 1 + 19 * index, 16, 57, 16, 16);
                color[0] = (color[0] & 0xFEFEFE) >> 1;
                color[1] = hasExp ? 4226832 : 9199709;
                color[2] = hasMat ? 4226832 : 9199709;
            } else {
                if (this.isMouseOverButton(index, mouseX, mouseY)) {
                    this.func_238474_b_(matrixStack, bX, bY + 19 * index, 0, 38, 108, 19);
                    color[0] = 0xFFFF80;
                } else {
                    this.func_238474_b_(matrixStack, bX, bY + 19 * index, 0, 0, 108, 19);
                }
                this.func_238474_b_(matrixStack, bX + 90, bY + 19 * index, 0, 57, 16, 16);
            }
            int width = 72 - this.field_230712_o_.func_78256_a("" + (expCost + matCost)) / 2;
            ITextProperties text = EnchantmentNameParts.func_178176_a().func_238816_a_(this.field_230712_o_, width);
            this.field_230712_o_.func_238418_a_(text, bX + 2, bY + 2 + 19 * index, width, color[0]);
            this.field_230712_o_.func_238405_a_(matrixStack, "" + expCost, (float)(bX + 106 - this.field_230712_o_.func_78256_a("" + expCost)), (float)(bY + 10 + 19 * index), color[1]);
            if (matCost <= 0) continue;
            this.renderMaterial(bX + 74, bY + 1 + 19 * index, "" + matCost, color[2]);
        }
    }

    private void renderMaterial(int x, int y, String display, int color) {
        ItemStack stack = ((ContainerEnderTable)this.field_147002_h).enchantIds[0] > -1 || ((ContainerEnderTable)this.field_147002_h).enchantIds[1] > -1 || ((ContainerEnderTable)this.field_147002_h).enchantIds[2] > -1 ? STACK_ENDER_DUST : ((ContainerEnderTable)this.field_147002_h).func_75139_a(1).func_75211_c();
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            this.field_230707_j_.func_175042_a(stack, x, y);
            MatrixStack matrixstack = new MatrixStack();
            matrixstack.func_227861_a_(0.0, 0.0, 200.0);
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            this.field_230712_o_.func_228079_a_(display, (float)(x + 16 - this.field_230712_o_.func_78256_a(display)), (float)(y + 9), color, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
            buffer.func_228461_a_();
        }
    }

    private boolean isMouseOverButton(int index, double mouseX, double mouseY) {
        return this.func_195359_a(66, 9 + 19 * index, 107, 17, mouseX, mouseY);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (int index = 0; index < 3; ++index) {
            int expCost;
            if (!this.isMouseOverButton(index, mouseX, mouseY) || (expCost = ((ContainerEnderTable)this.field_147002_h).experienceCost[index]) < 1) continue;
            int enchantId = ((ContainerEnderTable)this.field_147002_h).enchantIds[index];
            ArrayList list = Lists.newArrayList();
            if (enchantId >= 0) {
                if (this.canReadEnchants()) {
                    List<EnchantmentData> enchants = ((ContainerEnderTable)this.field_147002_h).getEnchantments(index, expCost);
                    for (EnchantmentData enchant : enchants) {
                        String s = enchant.field_76302_b.func_200305_d(enchant.field_76303_c).getString();
                        list.add(new StringTextComponent(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + s));
                    }
                } else {
                    Enchantment enchantment = Enchantment.func_185262_c((int)enchantId);
                    int l = ((ContainerEnderTable)this.field_147002_h).worldClue[index];
                    list.add(new StringTextComponent("" + TextFormatting.WHITE + TextFormatting.ITALIC + I18n.func_135052_a((String)"container.enchant.clue", (Object[])new Object[]{enchantment == null ? "" : enchantment.func_200305_d(l).getString()})));
                    if (enchantment == null) {
                        list.add(StringTextComponent.field_240750_d_);
                        list.add(new StringTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"forge.container.enchant.limitedEnchantability", (Object[])new Object[0])));
                    }
                }
            } else {
                String s = Localization.get((String)((ContainerEnderTable)this.field_147002_h).tooltips[index]);
                if (!this.canReadEnchants()) {
                    s = TextFormatting.OBFUSCATED.toString() + s.replace(" ", "");
                }
                list.add(new StringTextComponent(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + s));
            }
            this.func_243308_b(matrixStack, list, mouseX, mouseY);
            break;
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    private boolean canReadEnchants() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack headItem = player.func_184582_a(EquipmentSlotType.HEAD);
        return !headItem.func_190926_b() && TAG_MONOCLE.func_230235_a_((Object)headItem.func_77973_b());
    }
}

