/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.resources;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ColorMapLoader;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import shetiphian.terraqueous.client.misc.FoliageColor;

@OnlyIn(value=Dist.CLIENT)
public class FoliageColorReloadListener
implements ISelectiveResourceReloadListener {
    private static final ResourceLocation LIGHT_VIBRANT = new ResourceLocation("terraqueous:textures/colormap/lightvibrant.png");
    private static final ResourceLocation DARK_MEDIUM = new ResourceLocation("terraqueous:textures/colormap/darkmedium.png");
    private static final ResourceLocation PLUM_CHERRY = new ResourceLocation("terraqueous:textures/colormap/plumcherry.png");
    private static final ResourceLocation LIFE_DEATH = new ResourceLocation("terraqueous:textures/colormap/lifedeath.png");

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        int[][] colorBuffer = new int[4][65536];
        colorBuffer[0] = this.get(LIGHT_VIBRANT);
        colorBuffer[1] = this.get(DARK_MEDIUM);
        colorBuffer[2] = this.get(PLUM_CHERRY);
        colorBuffer[3] = this.get(LIFE_DEATH);
        FoliageColor.colorBuffer = colorBuffer;
    }

    private int[] get(ResourceLocation location) {
        try {
            return ColorMapLoader.func_217820_a((IResourceManager)Minecraft.func_71410_x().func_195551_G(), (ResourceLocation)location);
        }
        catch (Exception exception) {
            return new int[65536];
        }
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.TEXTURES;
    }
}

