/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockCactus
extends BushBlock
implements IPlantable,
IBonemealable {
    public static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);
    private static final VoxelShape SHAPE_SMALL = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape SHAPE_LARGE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);

    public BlockCactus() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)EnumType.SMALL)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(VARIANT) == EnumType.SMALL ? SHAPE_SMALL : SHAPE_LARGE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_177229_b(VARIANT) == EnumType.FRUIT) {
            Item fruit = Values.itemPlantFruit.get((Object)PlantAPI.PlantType.CACTUS);
            if (fruit != null) {
                if (player != null) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)fruit, world.field_73012_v.nextInt(2) + 1));
                } else {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)fruit, world.field_73012_v.nextInt(2) + 1));
                }
            }
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LARGE))), (boolean)true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && !(entity instanceof RabbitEntity)) {
            EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
            boolean hasBoots = !((LivingEntity)entity).func_184582_a(EquipmentSlotType.FEET).func_190926_b();
            boolean hasPants = !((LivingEntity)entity).func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
            float damage = 1.5f;
            damage = type == EnumType.SMALL ? (damage -= hasBoots ? 1.5f : 0.0f) : (damage -= hasBoots && hasPants ? 1.5f : 0.0f);
            if (damage > 0.0f) {
                entity.func_70097_a(DamageSource.field_76367_g, damage);
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
            return;
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        return state.func_177229_b(VARIANT) != EnumType.FRUIT;
    }

    public boolean canUseBonemeal(World world, Random rand, BlockPos pos, BlockState state) {
        return rand.nextFloat() < 0.45f;
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case SMALL: {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LARGE))), (boolean)true);
                break;
            }
            case LARGE: {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FRUIT))), (boolean)true);
            }
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case SMALL: {
                if (!PlantFunctions.canGrow((World)world, pos, PlantAPI.PlantType.CACTUS)) break;
                this.grow((World)world, random, pos, state);
                break;
            }
            case LARGE: {
                if (!world.func_175623_d(pos.func_177984_a()) || !PlantFunctions.canGrowFruit((World)world, pos, PlantAPI.PlantType.CACTUS)) break;
                this.grow((World)world, random, pos, state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_226659_b_(pos, 0) >= 8 && super.func_196260_a(state, world, pos);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return Tags.Blocks.SAND.func_230235_a_((Object)state.func_177230_c());
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }

    public static enum EnumType implements IStringSerializable
    {
        SMALL(0),
        LARGE(1),
        FRUIT(2);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[4];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

