/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.item.ItemBlockDryingHay;
import shetiphian.terraqueous.common.worldgen.BiomeHelper;

public class BlockDryingHay
extends Block
implements IColored {
    public static final IntegerProperty PROGRESS = IntegerProperty.func_177719_a((String)"progress", (int)0, (int)9);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static int[] COLORS = new int[]{4419621, 5273901, 6127925, 6982205, 7902021, 8756044, 9610324, 10530141, 11384164, 12172908};
    public static final ITag.INamedTag<Block> HIGH_TEMP = BlockTags.func_199894_a((String)"forge:high_temp");

    public BlockDryingHay() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PROGRESS});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, BlockDryingHay.getTickRate((IWorldReader)world, pos.func_177977_b()));
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (BlockDryingHay.getTickRate(world, pos.func_177977_b()) < 20) {
            return false;
        }
        VoxelShape shape = world.func_180495_p(pos.func_177977_b()).func_196952_d((IBlockReader)world, pos.func_177977_b());
        if (shape == VoxelShapes.func_197868_b() || Block.func_208061_a((VoxelShape)shape, (Direction)Direction.UP)) {
            return true;
        }
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB aabb = shape.func_197752_a();
        return aabb.field_72337_e >= 0.984375 && aabb.field_72340_a <= 0.015625 && aabb.field_72339_c <= 0.015625 && aabb.field_72336_d >= 0.984375 && aabb.field_72334_f >= 0.984375;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int progress = (Integer)state.func_177229_b((Property)PROGRESS);
        boolean isRaining = world.func_175727_C(pos);
        if (!isRaining) {
            if (progress < 9) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)PROGRESS, (Comparable)Integer.valueOf(progress + 1))), (boolean)true);
            } else {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)Values.blockHayPile.func_176223_P(), (boolean)true);
            }
        }
        if (isRaining || progress < 9) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, BlockDryingHay.getTickRate((IWorldReader)world, pos.func_177977_b()));
        }
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.state != null && data.state.func_177230_c() == this) {
            return COLORS[MathHelper.func_76125_a((int)((Integer)data.state.func_177229_b((Property)PROGRESS)), (int)0, (int)9)];
        }
        return 0xFFFFFF;
    }

    public static int getTickRate(IWorldReader world, BlockPos pos) {
        Fluid fluid;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (HIGH_TEMP.func_230235_a_((Object)block)) {
            return 300;
        }
        if ((Tags.Blocks.STONE.func_230235_a_((Object)block) || Tags.Blocks.COBBLESTONE.func_230235_a_((Object)block) || Tags.Blocks.SANDSTONE.func_230235_a_((Object)block)) && (fluid = world.func_204610_c(pos.func_177977_b()).func_206886_c()).getAttributes().getTemperature() >= 1300) {
            return 300;
        }
        Biome biome = world.func_226691_t_(pos);
        Biome.Category category = biome.func_201856_r();
        if (BiomeHelper.isCold(biome) || biome.func_76736_e()) {
            return 0;
        }
        if (category == Biome.Category.NETHER) {
            return 400;
        }
        if (BiomeHelper.isHot(biome) && (Tags.Blocks.SAND.func_230235_a_((Object)block) || Tags.Blocks.SANDSTONE.func_230235_a_((Object)block))) {
            return 600;
        }
        return 900;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return ItemBlockDryingHay.create(new ItemStack((IItemProvider)this), (Integer)state.func_177229_b((Property)PROGRESS));
    }
}

