/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class BlockEdge
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape[] SHAPES = BlockEdge.makeShapes();
    private static final int[] INDICES = new int[]{0, 1, 2, 3, 7, 4, 5, 6, 4, 5, 6, 7, 11, 8, 9, 10, 8, 9, 10, 11};

    private static VoxelShape[] makeShapes() {
        VoxelShape[] shapes;
        VoxelShape TOP_NW_CORNER = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        VoxelShape TOP_NE_CORNER = Block.func_208617_a((double)8.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        VoxelShape TOP_SW_CORNER = Block.func_208617_a((double)0.0, (double)12.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
        VoxelShape TOP_SE_CORNER = Block.func_208617_a((double)8.0, (double)12.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape BOTTOM_NW_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape BOTTOM_NE_CORNER = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape BOTTOM_SW_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
        VoxelShape BOTTOM_SE_CORNER = Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape BOTTOM_N_SIDE = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
        VoxelShape BOTTOM_W_SIDE = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
        VoxelShape BOTTOM_S_SIDE = Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape BOTTOM_E_SIDE = Block.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        shapes = new VoxelShape[]{VoxelShapes.func_216384_a((VoxelShape)TOP_SE_CORNER, (VoxelShape[])new VoxelShape[]{TOP_SW_CORNER, BOTTOM_SE_CORNER, BOTTOM_S_SIDE, BOTTOM_SW_CORNER}), VoxelShapes.func_216384_a((VoxelShape)TOP_SW_CORNER, (VoxelShape[])new VoxelShape[]{TOP_NW_CORNER, BOTTOM_SW_CORNER, BOTTOM_W_SIDE, BOTTOM_NW_CORNER}), VoxelShapes.func_216384_a((VoxelShape)TOP_NW_CORNER, (VoxelShape[])new VoxelShape[]{TOP_NE_CORNER, BOTTOM_NW_CORNER, BOTTOM_N_SIDE, BOTTOM_NE_CORNER}), VoxelShapes.func_216384_a((VoxelShape)TOP_NE_CORNER, (VoxelShape[])new VoxelShape[]{TOP_SE_CORNER, BOTTOM_NE_CORNER, BOTTOM_E_SIDE, BOTTOM_SE_CORNER}), VoxelShapes.func_216384_a((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{TOP_NW_CORNER, BOTTOM_W_SIDE, BOTTOM_NW_CORNER}), VoxelShapes.func_216384_a((VoxelShape)shapes[1], (VoxelShape[])new VoxelShape[]{TOP_NE_CORNER, BOTTOM_N_SIDE, BOTTOM_NE_CORNER}), VoxelShapes.func_216384_a((VoxelShape)shapes[2], (VoxelShape[])new VoxelShape[]{TOP_SE_CORNER, BOTTOM_E_SIDE, BOTTOM_SE_CORNER}), VoxelShapes.func_216384_a((VoxelShape)shapes[3], (VoxelShape[])new VoxelShape[]{TOP_SW_CORNER, BOTTOM_S_SIDE, BOTTOM_SW_CORNER}), VoxelShapes.func_197872_a((VoxelShape)TOP_SW_CORNER, (VoxelShape)BOTTOM_SW_CORNER), VoxelShapes.func_197872_a((VoxelShape)TOP_NW_CORNER, (VoxelShape)BOTTOM_NW_CORNER), VoxelShapes.func_197872_a((VoxelShape)TOP_NE_CORNER, (VoxelShape)BOTTOM_NE_CORNER), VoxelShapes.func_197872_a((VoxelShape)TOP_SE_CORNER, (VoxelShape)BOTTOM_SE_CORNER)};
        return shapes;
    }

    public BlockEdge(MaterialColor color) {
        this(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_200943_b(1.8f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    }

    public BlockEdge(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES[INDICES[this.getIndex(state)]];
    }

    private int getIndex(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(pos);
        BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)BlockEdge.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), pos));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a(SHAPE, (Comparable)BlockEdge.getShapeProperty(state, (IBlockReader)world, currentPos)) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader world, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState blockstate = world.func_180495_p(pos.func_177972_a(direction));
        if (BlockEdge.isEdgeBlock(blockstate) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && BlockEdge.isDifferentEdge(state, world, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (BlockEdge.isEdgeBlock(blockstate1) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && BlockEdge.isDifferentEdge(state, world, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentEdge(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        BlockState blockstate = world.func_180495_p(pos.func_177972_a(face));
        return !BlockEdge.isEdgeBlock(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING);
    }

    public static boolean isEdgeBlock(BlockState state) {
        return state.func_177230_c() instanceof BlockEdge;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirror);
    }
}

