/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockEndimium
extends Block {
    private static final Cache<Integer, Byte> cacheTeleport = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private static final VoxelShape COLLISION = VoxelShapes.func_197873_a((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
    private final boolean isOre;

    public BlockEndimium(boolean isOre) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193570_V).func_200948_a(isOre ? 3.0f : 5.0f, 15.0f).func_200947_a(SoundType.field_185851_d).func_235838_a_(state -> isOre ? 4 : 6).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.isOre = isOre;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return COLLISION;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return !(entity instanceof EnderDragonEntity);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        this.func_196262_a(world.func_180495_p(pos), world, pos, entity);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof LivingEntity && cacheTeleport.getIfPresent((Object)entity.func_145782_y()) == null && !entity.getClass().getName().toLowerCase().contains("ender")) {
            BlockEndimium.teleportEntity(world, pos, (LivingEntity)entity, this.isOre ? 4 : 16);
        }
    }

    public static void teleportEntity(World world, BlockPos pos, LivingEntity entity, int distance) {
        int targetX = (int)(entity.func_226277_ct_() + (double)world.field_73012_v.nextInt(distance * 2) - (double)distance);
        int targetY = (int)(entity.func_226278_cu_() + (double)world.field_73012_v.nextInt(distance * 2) - (double)(distance / 4));
        int targetZ = (int)(entity.func_226281_cx_() + (double)world.field_73012_v.nextInt(distance * 2) - (double)distance);
        double startX = entity.func_226277_ct_();
        double startY = entity.func_226278_cu_();
        double startZ = entity.func_226281_cx_();
        BlockPos target = new BlockPos(targetX, targetY, targetZ);
        if (world.func_175667_e(target)) {
            boolean spotGood = false;
            int height = MathHelper.func_76123_f((float)entity.func_213302_cg());
            while (!spotGood && target.func_177956_o() > 0) {
                if (world.func_175623_d(target) && world.func_180495_p(target.func_177977_b()).func_185904_a().func_76230_c()) {
                    spotGood = true;
                    for (int check = 1; check < height; ++check) {
                        if (world.func_175623_d(target.func_177981_b(check))) continue;
                        spotGood = false;
                    }
                }
                if (spotGood) continue;
                target = target.func_177977_b();
            }
            if (spotGood) {
                if (entity instanceof PlayerEntity) {
                    entity.func_70634_a((double)((float)targetX + 0.5f), (double)target.func_177956_o(), (double)((float)targetZ + 0.5f));
                } else {
                    entity.func_70107_b((double)((float)targetX + 0.5f), (double)target.func_177956_o(), (double)((float)targetZ + 0.5f));
                }
                int short1 = 128;
                for (int l = 0; l < short1; ++l) {
                    double d6 = (double)l / ((double)short1 - 1.0);
                    float xSpeed = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float ySpeed = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float zSpeed = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    double x = startX + (entity.func_226277_ct_() - startX) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.func_213311_cf() * 2.0;
                    double y = startY + (entity.func_226278_cu_() - startY) * d6 + world.field_73012_v.nextDouble() * (double)entity.func_213302_cg();
                    double z = startZ + (entity.func_226281_cx_() - startZ) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.func_213311_cf() * 2.0;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }
}

