/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.common.block.BlockCrafting;
import shetiphian.terraqueous.common.misc.StormForgeHelper;

public class BlockFurnace
extends BlockCrafting {
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

    public BlockFurnace(Supplier<? extends TileEntity> tile) {
        this(tile, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    }

    public BlockFurnace(Supplier<? extends TileEntity> tile, AbstractBlock.Properties builder) {
        super(tile, builder);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 13 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (random.nextDouble() < 0.1) {
                world.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public static class Cloud
    extends BlockFurnace
    implements ICloud {
        public Cloud(Supplier<? extends TileEntity> tile) {
            super(tile, CloudPresets.properties().func_200943_b(2.0f).harvestLevel(1));
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (!world.field_72995_K && placer instanceof PlayerEntity && this == Values.blockCloudCraftFurnace && StormForgeHelper.TAG_ALTER_BASE.func_230235_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) && ((Configuration.Menu_StormForge.LEVEL)((Object)Configuration.STORMFORGE.permissions.get())).check((PlayerEntity)placer)) {
                StormForgeHelper.createStormForge(world, pos);
            }
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return CloudPresets.isFlammable();
        }

        public PushReaction func_149656_h(BlockState state) {
            return CloudPresets.getPushReaction();
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
                return super.func_220071_b(state, world, pos, context);
            }
            return VoxelShapes.func_197880_a();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (CloudPresets.shouldCollide(state, (IBlockReader)world, pos, (Entity)player)) {
                return super.func_225533_a_(state, world, pos, player, hand, hit);
            }
            return ActionResultType.FAIL;
        }

        public void func_176199_a(World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityWalking(world, pos, entity);
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityCollision(state, world, pos, entity);
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
        }
    }
}

