/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;

public class BlockGardenFence
extends FourWayBlock
implements IColored,
IRGB16_Block {
    public static final BooleanProperty POST = BooleanProperty.func_177716_a((String)"post");
    private final VoxelShape[] wallShapes;
    private final GardenFence gardenFence;

    public BlockGardenFence(GardenFence type, Material material, float hardness, ToolType tool) {
        super(type.postWidth, type.extensionWidth, type.postHeight, type.extensionHeight, type.postHeight, AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(hardness, 0.5f).harvestTool(tool).harvestLevel(0));
        this.wallShapes = this.func_196408_a(type.postWidthAlt, type.extensionWidth, type.postHeightAlt, 0.0f, type.extensionHeight);
        this.gardenFence = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POST, (Comparable)Boolean.TRUE)).func_206870_a((Property)field_196409_a, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196411_b, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196413_c, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_196414_y, (Comparable)Boolean.FALSE)).func_206870_a((Property)field_204514_u, (Comparable)Boolean.FALSE));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.gardenFence == GardenFence.WAVE || this.gardenFence == GardenFence.SPEED) {
                RenderRegistry.COLORIZE.add((Object)this);
            }
        });
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POST, field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u});
    }

    public boolean hasTileEntity(BlockState state) {
        return this.gardenFence == GardenFence.WAVE || this.gardenFence == GardenFence.SPEED;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.gardenFence == GardenFence.WAVE ? new TileEntityRGB16(Values.tileRGB16) : (this.gardenFence == GardenFence.SPEED ? new TileEntityExtendedRedstone(Values.tileRedstone, 2) : null);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.gardenFence.hasHideablePost && (Boolean)state.func_177229_b((Property)POST) != false ? this.wallShapes[this.func_196406_i(state)] : super.func_220053_a(state, world, pos, context);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return !state.func_235785_r_(world, pos);
            }
            case WATER: {
                return world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
        }
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.gardenFence != GardenFence.SPEED || BlockGardenFence.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos nPos = blockpos.func_177978_c();
        BlockPos ePos = blockpos.func_177974_f();
        BlockPos sPos = blockpos.func_177968_d();
        BlockPos wPos = blockpos.func_177976_e();
        BlockState nState = world.func_180495_p(nPos);
        BlockState eState = world.func_180495_p(ePos);
        BlockState sState = world.func_180495_p(sPos);
        BlockState wState = world.func_180495_p(wPos);
        boolean flag = this.canConnect(nState, nState.func_224755_d((IBlockReader)world, nPos, Direction.SOUTH));
        boolean flag1 = this.canConnect(eState, eState.func_224755_d((IBlockReader)world, ePos, Direction.WEST));
        boolean flag2 = this.canConnect(sState, sState.func_224755_d((IBlockReader)world, sPos, Direction.NORTH));
        boolean flag3 = this.canConnect(wState, wState.func_224755_d((IBlockReader)world, wPos, Direction.EAST));
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196409_a, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)field_196411_b, (Comparable)Boolean.valueOf(flag1))).func_206870_a((Property)field_196413_c, (Comparable)Boolean.valueOf(flag2))).func_206870_a((Property)field_196414_y, (Comparable)Boolean.valueOf(flag3))).func_206870_a((Property)field_204514_u, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        if (this.gardenFence.hasHideablePost) {
            boolean flag4 = !(flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3);
            state = (BlockState)state.func_206870_a((Property)POST, (Comparable)Boolean.valueOf(flag4));
        } else {
            state = (BlockState)state.func_206870_a((Property)POST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)field_204514_u)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == Direction.DOWN) {
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        Direction direction = facing.func_176734_d();
        boolean flag = facing == Direction.NORTH ? this.canConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction)) : ((Boolean)state.func_177229_b((Property)field_196409_a)).booleanValue();
        boolean flag1 = facing == Direction.EAST ? this.canConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction)) : ((Boolean)state.func_177229_b((Property)field_196411_b)).booleanValue();
        boolean flag2 = facing == Direction.SOUTH ? this.canConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction)) : ((Boolean)state.func_177229_b((Property)field_196413_c)).booleanValue();
        boolean flag3 = facing == Direction.WEST ? this.canConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction)) : ((Boolean)state.func_177229_b((Property)field_196414_y)).booleanValue();
        state = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)field_196409_a, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)field_196411_b, (Comparable)Boolean.valueOf(flag1))).func_206870_a((Property)field_196413_c, (Comparable)Boolean.valueOf(flag2))).func_206870_a((Property)field_196414_y, (Comparable)Boolean.valueOf(flag3));
        if (this.gardenFence.hasHideablePost) {
            boolean flag4 = !(flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3);
            state = (BlockState)state.func_206870_a((Property)POST, (Comparable)Boolean.valueOf(flag4));
        } else {
            state = (BlockState)state.func_206870_a((Property)POST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private boolean canConnect(BlockState state, boolean hasSolidSide) {
        Block block = state.func_177230_c();
        return this.gardenFence.canConnectToOtherBlocks && !BlockGardenFence.func_220073_a((Block)block) && hasSolidSide || block == this;
    }

    private boolean isSingleAxis(BlockState state) {
        return ((Boolean)state.func_177229_b((Property)field_196409_a) != false || (Boolean)state.func_177229_b((Property)field_196413_c) != false) ^ ((Boolean)state.func_177229_b((Property)field_196411_b) != false || (Boolean)state.func_177229_b((Property)field_196414_y) != false);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return world.func_175625_s(pos) instanceof TileEntityExtendedRedstone;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        this.notifyRedstonePower(state, (IWorldReader)world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRGB16 && stack.func_77973_b() instanceof ItemBlockRGB) {
            ((TileEntityRGB16)tile).setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            this.notifyRedstonePower(state, (IWorldReader)world, pos);
            super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        }
    }

    private void notifyRedstonePower(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity tile;
        if (!world.func_201670_d() && this.canConnectRedstone(state, (IBlockReader)world, pos, Direction.DOWN) && (tile = world.func_175625_s(pos)) instanceof TileEntityExtendedRedstone) {
            ((TileEntityExtendedRedstone)tile).setEnabled(this.isSingleAxis(state));
            ((TileEntityExtendedRedstone)tile).updatePower();
        }
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return 0;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (this.canConnectRedstone(state, world, pos, side)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof TileEntityExtendedRedstone ? ((TileEntityExtendedRedstone)tile).getRSPower() : 0;
        }
        return 0;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity entityLiving = (LivingEntity)entity;
            VoxelShape shape = state.func_215700_a((IBlockReader)world, pos, ISelectionContext.func_216374_a((Entity)entity));
            if (shape.func_197766_b()) {
                return;
            }
            if (entity.func_174813_aQ().func_72326_a(shape.func_197752_a().func_186670_a(pos))) {
                boolean isPlayer = entity instanceof PlayerEntity;
                switch (this.gardenFence) {
                    case WAVE: {
                        entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d));
                        break;
                    }
                    case SPIKE: {
                        entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                        entityLiving.func_195063_d(Effects.field_76424_c);
                        entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d, 20));
                        break;
                    }
                    case TRANSMUTE: {
                        if (!isPlayer) {
                            BlueFlowerHandler.INSTANCE.mobTransmute(entity, false);
                        }
                        entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d));
                        break;
                    }
                    case NECROTIC: {
                        if (!isPlayer) {
                            BlueFlowerHandler.INSTANCE.mobTransmute(entity, true);
                        }
                        entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d));
                        break;
                    }
                    case SPEED: {
                        TileEntity tile = world.func_175625_s(pos);
                        if (!this.isSingleAxis(state) || !(tile instanceof TileEntityExtendedRedstone)) break;
                        int power = ((TileEntityExtendedRedstone)tile).getRSPower();
                        entityLiving.func_195063_d(Effects.field_76421_d);
                        entityLiving.func_195064_c(new EffectInstance((Boolean)state.func_177229_b((Property)field_204514_u) != false ? Effects.field_206827_D : Effects.field_76424_c, (power % 5 + 1) * 20, power / 5));
                    }
                }
            }
        }
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vector3d hitVec, String dyeName) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRGB16) {
            boolean changed = false;
            if (!world.func_201670_d()) {
                changed = player == null ? ((TileEntityRGB16)tile).getRGB16(null).setValues(dyeName) : ((TileEntityRGB16)tile).getRGB16(player).recolor(player, dyeName);
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return changed;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            TileEntity tile = data.world.func_175625_s(data.pos);
            if (tile instanceof TileEntityRGB16) {
                return ((TileEntityRGB16)tile).getRGB16(null).getColor();
            }
            if (tile instanceof TileEntityExtendedRedstone) {
                return RedstoneWireBlock.func_235550_b_((int)((TileEntityExtendedRedstone)tile).getRSPower());
            }
        }
        return 0xFFFFFF;
    }

    public static enum GardenFence {
        WAVE(false, true, 0.5f, 0.5f, 6.0f, 8.0f, 0.0f, 0.0f),
        SPIKE(false, true),
        TRANSMUTE(false, true),
        NECROTIC(false, true),
        SPEED(true, false, 0.5f, 2.5f, 0.0f, 0.1f, 0.5f, 8.0f);

        private final boolean hasHideablePost;
        private final boolean canConnectToOtherBlocks;
        private final float postWidth;
        private final float extensionWidth;
        private final float postHeight;
        private final float extensionHeight;
        private final float postWidthAlt;
        private final float postHeightAlt;

        private GardenFence(boolean post, boolean others) {
            this(post, others, 0.5f, 0.5f, 8.0f, 8.0f, 0.0f, 0.0f);
        }

        private GardenFence(boolean post, boolean others, float postWidth, float extensionWidth, float postHeight, float extensionHeight, float postWidthAlt, float postHeightAlt) {
            this.hasHideablePost = post;
            this.canConnectToOtherBlocks = others;
            this.postWidth = postWidth;
            this.extensionWidth = extensionWidth;
            this.postHeight = postHeight;
            this.extensionHeight = extensionHeight;
            this.postWidthAlt = postWidthAlt;
            this.postHeightAlt = postHeightAlt;
        }
    }
}

