/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.block.BlockWall;
import shetiphian.terraqueous.common.item.ItemBlockRGB;

public class BlockPicketFence
extends BlockWall
implements IColored,
IRGB16_Block {
    public BlockPicketFence() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0), 1.0f, 12.0f, 16.0f, 0.5f, 0.0f, 16.0f, 16.0f);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRGB16(Values.tileRGB16);
    }

    @Override
    protected boolean shouldConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.func_177230_c();
        boolean lvt_5_1_ = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)state, (Direction)direction);
        return state.func_235714_a_((ITag)BlockTags.field_219748_G) || !BlockPicketFence.func_220073_a((Block)block) && isSideSolid || block instanceof PaneBlock || lvt_5_1_;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRGB16 && stack.func_77973_b() instanceof ItemBlockRGB) {
            ((TileEntityRGB16)tile).setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vector3d hitVec, String dyeName) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRGB16) {
            boolean changed = false;
            if (!world.func_201670_d()) {
                changed = player == null ? ((TileEntityRGB16)tile).getRGB16(null).setValues(dyeName) : ((TileEntityRGB16)tile).getRGB16(player).recolor(player, dyeName);
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return changed;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            TileEntity tile = data.world.func_175625_s(data.pos);
            if (tile instanceof TileEntityRGB16) {
                return ((TileEntityRGB16)tile).getRGB16(null).getColor();
            }
            if (tile instanceof TileEntityExtendedRedstone) {
                return RedstoneWireBlock.func_235550_b_((int)((TileEntityExtendedRedstone)tile).getRSPower());
            }
        }
        return 0xFFFFFF;
    }
}

