/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.IColored;

public class BlockPile
extends Block
implements IColored {
    public static final IntegerProperty STACKED = IntegerProperty.func_177719_a((String)"stacked", (int)0, (int)8);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final boolean damageReduction;
    private final Pair<IColored, BlockState> colorProvider;

    public BlockPile(AbstractBlock.Properties properties, boolean damageReduction) {
        this(properties, damageReduction, null);
    }

    public BlockPile(AbstractBlock.Properties properties, boolean damageReduction, BlockState colorState) {
        super(properties.func_226896_b_());
        this.damageReduction = damageReduction;
        this.colorProvider = colorState != null && colorState.func_177230_c() instanceof IColored ? Pair.of((Object)((IColored)colorState.func_177230_c()), (Object)colorState) : null;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STACKED, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STACKED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((Property)STACKED) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)STACKED)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int stacked = (Integer)state.func_177229_b((Property)STACKED);
        return stacked < 2 ? VoxelShapes.func_197880_a() : SHAPES[stacked - 1];
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        VoxelShape shape = world.func_180495_p(pos.func_177977_b()).func_196952_d((IBlockReader)world, pos.func_177977_b());
        if (shape == VoxelShapes.func_197868_b() || Block.func_208061_a((VoxelShape)shape, (Direction)Direction.UP)) {
            return true;
        }
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB aabb = shape.func_197752_a();
        return aabb.field_72337_e >= 0.984375 && aabb.field_72340_a <= 0.015625 && aabb.field_72339_c <= 0.015625 && aabb.field_72336_d >= 0.984375 && aabb.field_72334_f >= 0.984375;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int layers = (Integer)state.func_177229_b((Property)STACKED);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && layers < 8) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c() == this) {
            int layers = (Integer)state.func_177229_b((Property)STACKED);
            return (BlockState)state.func_206870_a((Property)STACKED, (Comparable)Integer.valueOf(Math.min(8, layers + 1)));
        }
        return super.func_196258_a(context);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            BlockState down;
            int layers = (Integer)state.func_177229_b((Property)STACKED);
            fallDistance = layers == 8 ? 0.0f : ((down = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof BlockPile && ((BlockPile)down.func_177230_c()).damageReduction ? 0.0f : Math.max(0.0f, fallDistance - fallDistance * ((float)layers / 8.0f)));
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    public int getColorFor(IColored.Data data, int index) {
        return this.colorProvider == null ? 0xFFFFFF : ((IColored)this.colorProvider.getLeft()).getColorFor(new IColored.Data((BlockState)this.colorProvider.getRight(), data.world, data.pos), index);
    }
}

