/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.tileentity.TileEntityPlanter;

public class BlockPlanter
extends Block
implements IColored,
IRGB16_Block {
    public static final EnumProperty<SoilType> SOIL = EnumProperty.func_177709_a((String)"soil", SoilType.class);
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty NORTH_EAST = BooleanProperty.func_177716_a((String)"northeast");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH_EAST = BooleanProperty.func_177716_a((String)"southeast");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty SOUTH_WEST = BooleanProperty.func_177716_a((String)"southwest");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty NORTH_WEST = BooleanProperty.func_177716_a((String)"northwest");
    public static final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private static final Material MATERIAL = new Material(MaterialColor.field_151667_k, false, false, true, false, false, false, PushReaction.IGNORE);

    public BlockPlanter() {
        super(AbstractBlock.Properties.func_200945_a((Material)MATERIAL).func_200944_c().func_200943_b(2.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_226896_b_().func_235861_h_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(SOIL, (Comparable)((Object)SoilType.NONE))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH_WEST, (Comparable)Boolean.valueOf(false)));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SOIL, NORTH, NORTH_EAST, EAST, SOUTH_EAST, SOUTH, SOUTH_WEST, WEST, NORTH_WEST});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityPlanter();
    }

    private TileEntityPlanter getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityPlanter ? (TileEntityPlanter)tile : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(SOIL) == SoilType.NONE || ((SoilType)((Object)state.func_177229_b(SOIL))).isFluid()) {
            if (!SHAPES.containsKey(state)) {
                VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
                if (!((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
                    shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.0, (double)1.5, (double)0.0, (double)16.0, (double)16.0, (double)1.5));
                }
                if (!((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
                    shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.0, (double)1.5, (double)14.5, (double)16.0, (double)16.0, (double)16.0));
                }
                if (!((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
                    shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)14.5, (double)1.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                }
                if (!((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
                    shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.0, (double)1.5, (double)0.0, (double)1.5, (double)16.0, (double)16.0));
                }
                SHAPES.put(state, shape);
            }
            if (SHAPES.containsKey(state)) {
                return SHAPES.get(state);
            }
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnections(this.func_176223_P(), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityPlanter tile = this.getTile((IBlockReader)world, pos);
        if (tile != null && stack.func_77973_b() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.getConnections(state, world, currentPos);
    }

    private BlockState getConnections(BlockState state, IWorld world, BlockPos pos) {
        BlockState result = state;
        BlockPos north = pos.func_177978_c();
        BlockPos south = pos.func_177968_d();
        result = (BlockState)result.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, north)));
        result = (BlockState)result.func_206870_a((Property)NORTH_EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, north.func_177974_f())));
        result = (BlockState)result.func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos.func_177974_f())));
        result = (BlockState)result.func_206870_a((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, south.func_177974_f())));
        result = (BlockState)result.func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, south)));
        result = (BlockState)result.func_206870_a((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, south.func_177976_e())));
        result = (BlockState)result.func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos.func_177976_e())));
        result = (BlockState)result.func_206870_a((Property)NORTH_WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, north.func_177976_e())));
        return result;
    }

    private boolean canConnect(BlockState state, IWorld world, BlockPos pos) {
        SoilType soil = (SoilType)((Object)state.func_177229_b(SOIL));
        if (soil == SoilType.TOOLS) {
            return false;
        }
        BlockState oState = world.func_180495_p(pos);
        if (oState.func_177230_c() == this) {
            SoilType oSoil = (SoilType)((Object)oState.func_177229_b(SOIL));
            return oSoil != SoilType.TOOLS && (!soil.isFluid() && !oSoil.isFluid() || soil == oSoil);
        }
        return false;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177229_b(SOIL) == SoilType.LAVA ? Fluids.field_204547_b.getAttributes().getLuminosity() : 0;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            BlockPos up = pos.func_177984_a();
            world.func_180495_p(up).func_227034_b_(world, up, random);
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (facing == Direction.UP) {
            return ((SoilType)((Object)state.func_177229_b(SOIL))).supportedPlantTypes.contains(plantable.getPlantType(world, pos.func_177972_a(facing)));
        }
        return false;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177229_b(SOIL) == SoilType.FARMLAND;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        TileEntityPlanter tile = this.getTile((IBlockReader)world, pos);
        if (tile == null || player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        SoilType soilType = (SoilType)((Object)state.func_177229_b(SOIL));
        if (heldStack.func_190926_b()) {
            if (soilType != SoilType.NONE && !soilType.isFluid()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)tile.getSoilBlock());
                }
                tile.setSoilBlock(ItemStack.field_190927_a);
                world.func_180501_a(pos, (BlockState)state.func_206870_a(SOIL, (Comparable)((Object)SoilType.NONE)), 3);
                soilType.playSound(world, pos, player, false);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (soilType == SoilType.DIRT && (heldStack.func_77973_b() instanceof HoeItem || heldStack.func_77973_b().getToolTypes(heldStack).contains(ToolType.get((String)"hoe")))) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a(SOIL, (Comparable)((Object)SoilType.FARMLAND)), 3);
            soilType.playSound(world, pos, player, false);
            return ActionResultType.SUCCESS;
        }
        if (soilType == SoilType.NONE || soilType.isFluid()) {
            AtomicReference<ActionResultType> resultType = new AtomicReference<ActionResultType>(ActionResultType.PASS);
            FluidUtil.getFluidHandler((ItemStack)heldStack).ifPresent(handler -> {
                resultType.set(ActionResultType.FAIL);
                if (soilType == SoilType.NONE) {
                    Fluid fluid;
                    FluidStack fluidStack = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                    if (!(fluidStack.isEmpty() || (fluid = fluidStack.getFluid()) != Fluids.field_204546_a && fluid != Fluids.field_204547_b)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        }
                        tile.setSoilFluid(fluidStack);
                        SoilType newSoilType = fluid == Fluids.field_204547_b ? SoilType.LAVA : SoilType.WATER;
                        world.func_180501_a(pos, (BlockState)state.func_206870_a(SOIL, (Comparable)((Object)newSoilType)), 3);
                        newSoilType.playSound(world, pos, player, true);
                        resultType.set(ActionResultType.SUCCESS);
                    }
                } else {
                    FluidStack fluidStack;
                    FluidStack fluidStack2 = fluidStack = tile.getSoilFluid().isEmpty() ? new FluidStack(soilType.fluid, 1000) : tile.getSoilFluid();
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        }
                        int otherSources = 0;
                        if (soilType == SoilType.WATER && ((Boolean)Configuration.TWEAKS.planterInfiniteWater.get()).booleanValue()) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                BlockState oState = world.func_180495_p(pos.func_177972_a(direction));
                                if (!(oState.func_177230_c() instanceof BlockPlanter) || oState.func_177229_b(SOIL) != SoilType.WATER) continue;
                                ++otherSources;
                            }
                        }
                        if (otherSources < 2) {
                            tile.setSoilFluid(FluidStack.EMPTY);
                            world.func_180501_a(pos, (BlockState)state.func_206870_a(SOIL, (Comparable)((Object)SoilType.NONE)), 3);
                        }
                        soilType.playSound(world, pos, player, false);
                        resultType.set(ActionResultType.SUCCESS);
                    }
                }
            });
            if (resultType.get() != ActionResultType.PASS) {
                return resultType.get();
            }
        }
        boolean isSpade = heldStack.func_77973_b().getToolTypes(heldStack).contains(ToolType.SHOVEL);
        if (heldStack.func_77973_b() instanceof BlockItem && !(((BlockItem)heldStack.func_77973_b()).func_179223_d() instanceof IPlantable) || isSpade) {
            SoilType newSoilType = SoilType.NONE;
            if (isSpade) {
                newSoilType = SoilType.TOOLS;
            } else {
                Block block = ((BlockItem)heldStack.func_77973_b()).func_179223_d();
                if (Tags.Blocks.DIRT.func_230235_a_((Object)block)) {
                    newSoilType = SoilType.DIRT;
                } else if (block == Blocks.field_150458_ak) {
                    newSoilType = SoilType.FARMLAND;
                } else if (Tags.Blocks.SAND.func_230235_a_((Object)block)) {
                    newSoilType = SoilType.SAND;
                } else if (Tags.Blocks.GRAVEL.func_230235_a_((Object)block)) {
                    newSoilType = SoilType.GRAVEL;
                } else if (block == Blocks.field_150425_aM) {
                    newSoilType = SoilType.SOULSAND;
                } else if (Tags.Blocks.END_STONES.func_230235_a_((Object)block)) {
                    newSoilType = SoilType.ENDSTONE;
                }
            }
            if (newSoilType != SoilType.NONE) {
                tile.setSoilBlock(heldStack);
                world.func_180501_a(pos, (BlockState)state.func_206870_a(SOIL, (Comparable)((Object)newSoilType)), 3);
                newSoilType.playSound(world, pos, player, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack itemStack;
                    heldStack.func_190918_g(1);
                    ItemStack itemStack2 = itemStack = tile.getSoilBlock().func_190926_b() ? soilType.getItem() : tile.getSoilBlock();
                    if (!itemStack.func_190926_b()) {
                        Function.giveItem((PlayerEntity)player, (ItemStack)itemStack);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vector3d hitVec, String dyeName) {
        TileEntityPlanter tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((IBlockReader)world, pos)) != null) {
            if (!world.func_201670_d()) {
                if (player == null) {
                    tile.getRGB16(null).setValues(dyeName);
                } else {
                    tile.getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.world != null && data.pos != null) {
            if (index == 0) {
                TileEntityPlanter tile = this.getTile((IBlockReader)data.world, data.pos);
                if (tile != null) {
                    return tile.getRGB16(null).getColor();
                }
            } else if (index == 1 && data.state != null && data.state.func_177229_b(SOIL) == SoilType.WATER) {
                return BiomeColors.func_228363_c_((IBlockDisplayReader)data.world, (BlockPos)data.pos);
            }
        }
        return 0xFFFFFF;
    }

    public boolean addLandingEffects(BlockState state, ServerWorld world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return ParticleHelper.addLandingEffects((ServerWorld)world, (Entity)entity, (int)numberOfParticles, (BlockState)this.getParticleState(state, (World)world, pos));
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (BlockState)this.getParticleState(state, world, pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos;
        BlockState soil;
        BlockRayTraceResult traceResult;
        if (target instanceof BlockRayTraceResult && (traceResult = (BlockRayTraceResult)target).func_216354_b() == Direction.UP && (soil = this.getParticleState(state, world, pos = traceResult.func_216350_a())) != state) {
            return ParticleHelper.addHitEffects((BlockState)state, (World)world, (BlockPos)pos, (Direction)traceResult.func_216354_b(), (ParticleManager)manager, (BlockState)soil);
        }
        return false;
    }

    private BlockState getParticleState(BlockState state, World world, BlockPos pos) {
        BlockState soil;
        TileEntityPlanter tile;
        if (state.func_177230_c() == this && (tile = this.getTile((IBlockReader)world, pos)) != null && (soil = tile.getSoilState()) != null) {
            return soil;
        }
        return state;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack soilStack;
        List drops = super.func_220076_a(state, builder);
        TileEntity builderTile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (builderTile instanceof TileEntityPlanter && !(soilStack = ((TileEntityPlanter)builderTile).getPickBlock()).func_190926_b()) {
            drops.add(soilStack);
        }
        return drops;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityPlanter tile = this.getTile(world, pos);
        if (tile != null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)tile.getRGB16(null));
        }
        return stack;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack;
        TileEntityPlanter tile;
        if (player.func_213453_ef() && (tile = this.getTile(world, pos)) != null && !(stack = tile.getPickBlock()).func_190926_b()) {
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static enum SoilType implements IStringSerializable
    {
        NONE(Blocks.field_150350_a, new PlantType[]{null}),
        TOOLS(Blocks.field_150350_a, new PlantType[]{null}),
        DIRT(Blocks.field_150346_d, PlantType.PLAINS, PlantType.BEACH, PlantType.CAVE),
        FARMLAND(Blocks.field_150458_ak, PlantType.CROP),
        SAND(Blocks.field_150354_m, PlantType.DESERT, PlantType.BEACH, PlantType.CAVE),
        GRAVEL(Blocks.field_150351_n, PlantType.DESERT, PlantType.BEACH, PlantType.CAVE),
        SOULSAND(Blocks.field_150425_aM, PlantType.NETHER),
        ENDSTONE(Blocks.field_150377_bs, PlantType.get((String)"end")),
        WATER(Fluids.field_204546_a, PlantType.WATER),
        LAVA(Fluids.field_204547_b, PlantType.get((String)"lava"));

        private final List<PlantType> supportedPlantTypes;
        private final Block block;
        private final Fluid fluid;

        private SoilType(Object object, PlantType ... plant) {
            this.supportedPlantTypes = plant == null ? Collections.emptyList() : (plant.length == 1 ? Collections.singletonList(plant[0]) : Arrays.asList(plant));
            if (object instanceof Block) {
                this.block = (Block)object;
                this.fluid = null;
            } else if (object instanceof Fluid) {
                this.block = null;
                this.fluid = (Fluid)object;
            } else {
                this.block = null;
                this.fluid = null;
            }
        }

        public boolean isFluid() {
            return this == WATER || this == LAVA;
        }

        public void playSound(World world, BlockPos pos, PlayerEntity player, boolean place) {
            if (this != NONE) {
                SoundEvent soundEvent = null;
                if (this == TOOLS) {
                    soundEvent = SoundEvents.field_187713_n;
                } else if (this.isFluid() && this.fluid != null) {
                    if (this == LAVA) {
                        soundEvent = place ? SoundEvents.field_187633_N : SoundEvents.field_187627_L;
                    } else {
                        SoundEvent soundEvent2 = soundEvent = place ? this.fluid.getAttributes().getFillSound() : this.fluid.getAttributes().getEmptySound();
                        if (soundEvent == null) {
                            soundEvent = place ? SoundEvents.field_187630_M : SoundEvents.field_187624_K;
                        }
                    }
                } else if (!this.isFluid() && this.block != null) {
                    SoundEvent soundEvent3 = soundEvent = place ? this.block.func_176223_P().func_215695_r().func_185841_e() : this.block.func_176223_P().func_215695_r().func_185845_c();
                }
                if (soundEvent != null) {
                    world.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            }
        }

        public ItemStack getItem() {
            if (this == NONE) {
                return ItemStack.field_190927_a;
            }
            if (this == TOOLS) {
                return new ItemStack((IItemProvider)Items.field_151051_r);
            }
            if (this.isFluid()) {
                return FluidUtil.getFilledBucket((FluidStack)new FluidStack(this.fluid, 1000));
            }
            return new ItemStack((IItemProvider)this.block.func_199767_j());
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

