/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;

public class BlockPressurePlate {
    protected static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public static class Cloud
    extends PressurePlateBlock
    implements ICloud,
    IWaterLoggable {
        public Cloud(MaterialColor color) {
            super(PressurePlateBlock.Sensitivity.EVERYTHING, CloudPresets.properties(color).func_200942_a().func_200943_b(0.2f));
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }

        public FluidState func_204507_t(BlockState state) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (state != null) {
                return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
            }
            return state;
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return CloudPresets.isFlammable();
        }

        public PushReaction func_149656_h(BlockState state) {
            return CloudPresets.getPushReaction();
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
                return super.func_220071_b(state, world, pos, context);
            }
            return VoxelShapes.func_197880_a();
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (CloudPresets.shouldCollide(state, (IBlockReader)world, pos, (Entity)player)) {
                return super.func_225533_a_(state, world, pos, player, hand, hit);
            }
            return ActionResultType.FAIL;
        }

        public void func_176199_a(World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityWalking(world, pos, entity);
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityCollision(state, world, pos, entity);
            if (CloudPresets.shouldCollide(state, (IBlockReader)world, pos, entity)) {
                super.func_196262_a(state, world, pos, entity);
            }
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
        }
    }

    public static class Wood
    extends PressurePlateBlock
    implements IWaterLoggable {
        public Wood(MaterialColor color) {
            super(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0));
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }

        public FluidState func_204507_t(BlockState state) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (state != null) {
                return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
            }
            return state;
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
    }
}

