/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.feature.FeatureAppleTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureBananaTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCherryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCoconutTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureLemonTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMangoTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMulberryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureOrangeTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePeachTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePearTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePlumTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class BlockSapling
extends SaplingBlock {
    private final PlantAPI.TreeType treeType;

    public BlockSapling(PlantAPI.TreeType treeType) {
        super(null, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.treeType = treeType;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_200014_a_(state, world, pos) || this.treeType == PlantAPI.TreeType.COCONUT && Tags.Blocks.SAND.func_230235_a_((Object)state.func_177230_c());
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.isAreaLoaded(pos, 1) && world.func_201696_r(pos.func_177984_a()) >= 9 && PlantFunctions.canSaplingGrow((IBlockReader)world, pos, this.treeType)) {
            this.func_225535_a_(world, random, pos, state);
        }
    }

    public void func_226942_a_(ServerWorld world, BlockPos pos, BlockState state, Random random) {
        if ((Integer)state.func_177229_b((Property)field_176479_b) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)field_176479_b), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)random, (BlockPos)pos)) {
                return;
            }
            this.spawn(world, pos, state, random);
        }
    }

    public boolean spawn(ServerWorld world, BlockPos pos, BlockState blockUnder, Random random) {
        FeatureTreeBase treeFeature = BlockSapling.getTreeFeature(this.treeType);
        if (treeFeature == null) {
            return false;
        }
        if (ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)random, (BlockPos)pos)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
            if (treeFeature.func_241855_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos, IFeatureConfig.field_202429_e)) {
                return true;
            }
            world.func_180501_a(pos, blockUnder, 4);
            return false;
        }
        return false;
    }

    private static FeatureTreeBase getTreeFeature(PlantAPI.TreeType treeType) {
        switch (treeType) {
            case APPLE: {
                return new FeatureAppleTree(true);
            }
            case CHERRY: {
                return new FeatureCherryTree(true);
            }
            case ORANGE: {
                return new FeatureOrangeTree(true);
            }
            case PEAR: {
                return new FeaturePearTree(true);
            }
            case PEACH: {
                return new FeaturePeachTree(true);
            }
            case MANGO: {
                return new FeatureMangoTree(true);
            }
            case LEMON: {
                return new FeatureLemonTree(true);
            }
            case PLUM: {
                return new FeaturePlumTree(true);
            }
            case BANANA: {
                return new FeatureBananaTree(true);
            }
            case COCONUT: {
                return new FeatureCoconutTree(true);
            }
            case MULBERRY: {
                return new FeatureMulberryTree(true);
            }
        }
        return null;
    }
}

