/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity.ai;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.server.ServerWorld;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockFlowers;

public class TaskTrimOvergrowth
extends Task<VillagerEntity> {
    private Block blockGrass = Values.blockPlants.getOrDefault((Object)PlantAPI.PlantType.GRASS, null);
    private BlockPos posPlant;
    private long taskCooldown;
    private int idleTime;

    public TaskTrimOvergrowth() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    protected boolean shouldExecute(ServerWorld world, VillagerEntity villager) {
        if (!((Boolean)Configuration.TWEAKS.VILLAGER.villageGardnerWeeds.get()).booleanValue()) {
            return false;
        }
        RegistryKey dimensionKey = world.func_234923_W_();
        BlockPos villagerPosition = villager.func_233580_cy_();
        ArrayList list = Lists.newArrayList();
        int range = 8;
        for (int x = -range; x <= range; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = villagerPosition.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof BlockFlowers) && (this.blockGrass == null || block != this.blockGrass)) continue;
                    list.add(GlobalPos.func_239648_a_((RegistryKey)dimensionKey, (BlockPos)pos));
                }
            }
        }
        if (!list.isEmpty()) {
            this.posPlant = ((GlobalPos)list.get(world.field_73012_v.nextInt(list.size()))).func_218180_b();
            return true;
        }
        return false;
    }

    protected void startExecuting(ServerWorld world, VillagerEntity villager, long gameTime) {
        if (gameTime > this.taskCooldown && this.posPlant != null) {
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.posPlant));
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new BlockPosWrapper(this.posPlant), 0.5f, 1));
        }
    }

    protected void resetTask(ServerWorld world, VillagerEntity villager, long gameTime) {
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        this.idleTime = 0;
        this.taskCooldown = gameTime + 10L;
    }

    protected void updateTask(ServerWorld world, VillagerEntity villager, long gameTime) {
        if (this.posPlant == null) {
            ++this.idleTime;
        } else if (this.posPlant.func_218137_a((IPosition)villager.func_213303_ch(), 1.73)) {
            if (this.posPlant != null && gameTime > this.taskCooldown) {
                villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.posPlant));
                BlockState statePlant = world.func_180495_p(this.posPlant);
                Block blockPlant = statePlant.func_177230_c();
                int count = 0;
                int range = 3;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            BlockPos pos = this.posPlant.func_177982_a(x, y, z);
                            if (world.func_180495_p(pos).func_177230_c() != blockPlant || ++count <= 3) continue;
                            world.func_217377_a(this.posPlant, false);
                            this.posPlant = null;
                            return;
                        }
                    }
                }
                if (blockPlant instanceof BlockFlowers && (Integer)statePlant.func_177229_b((Property)BlockFlowers.SIZE) > 0) {
                    world.func_175656_a(this.posPlant, (BlockState)statePlant.func_206870_a((Property)BlockFlowers.SIZE, (Comparable)Integer.valueOf(0)));
                }
            }
        } else {
            ++this.idleTime;
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.posPlant));
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new BlockPosWrapper(this.posPlant), 0.5f, 1));
        }
    }

    protected boolean shouldContinueExecuting(ServerWorld world, VillagerEntity villager, long gameTime) {
        return this.idleTime < 200;
    }
}

