/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.TileEntity;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IGhostSlots;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;

public class ContainerCraftBench
extends SidedContainer<TileEntityCraftBench> {
    private final TileEntityCraftBench bench;
    private final PlayerInventory invPlayer;
    private final GhostMatrixCrafting craftMatrix;
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private ItemStack lastStackInSlot;

    public ContainerCraftBench(int id, PlayerInventory invPlayer, TileEntityCraftBench tile) {
        super(Values.Container.CRAFTBENCH, id, (TileEntity)tile);
        int col;
        int row;
        this.bench = tile;
        this.invPlayer = invPlayer;
        this.craftMatrix = new GhostMatrixCrafting((IInventory)this.bench.ghostMatrix);
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.func_75146_a((Slot)new IGhostSlots.SlotGhost((IInventory)this.craftMatrix, col + row * 3, 38 + col * 18, 11 + row * 18));
            }
        }
        this.func_75146_a((Slot)new SlotGhostCrafting(this, 0, 128, 16));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.bench.inventory, col + row * 9 + 1, 11 + col * 18, 70 + row * 18));
            }
        }
        this.func_75146_a((Slot)new IOutputSlot.SlotOutput((IInventory)this.bench.inventory, 28, 119, 40, null));
        this.func_75146_a((Slot)new IOutputSlot.SlotOutput((IInventory)this.bench.inventory, 29, 137, 40, null));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)invPlayer, col + row * 9 + 9, 11 + col * 18, 146 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)invPlayer, col, 11 + col * 18, 204));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.bench.inventory.func_70300_a(player);
    }

    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, PlayerEntity player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof IGhostSlots && mouseButton != 2) {
            ItemStack stack;
            if (mouseButton == 0 && clickType == ClickType.PICKUP_ALL) {
                stack = ItemStack.field_190927_a;
                try {
                    stack = player.field_71071_by.func_70445_o().func_77946_l();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
                    stack.func_190920_e(1);
                }
                if (!this.lastStackInSlot.func_190926_b()) {
                    for (int index = 0; index < this.craftMatrix.func_70302_i_(); index = (int)((byte)(index + 1))) {
                        if (!Function.areItemStacksEqual((ItemStack)this.craftMatrix.func_70301_a(index), (ItemStack)this.lastStackInSlot)) continue;
                        this.craftMatrix.func_70299_a(index, stack);
                    }
                }
            }
            if (mouseButton == 0 || mouseButton == 1 || clickType == ClickType.QUICK_CRAFT) {
                this.lastStackInSlot = slot.func_75211_c();
                stack = ItemStack.field_190927_a;
                try {
                    stack = player.field_71071_by.func_70445_o().func_77946_l();
                }
                catch (NullPointerException index) {
                    // empty catch block
                }
                if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
                    stack.func_190920_e(1);
                }
                slot.func_75215_d(stack);
            }
            this.func_75130_a(null);
            return slot.func_75211_c();
        }
        Slot output = (Slot)this.field_75151_b.get(9);
        ItemStack crafted = output.func_75211_c();
        if (clickType == ClickType.PICKUP_ALL) {
            output.func_75215_d(ItemStack.field_190927_a);
        }
        ItemStack result = super.func_184996_a(slotId, mouseButton, clickType, player);
        output.func_75215_d(crafted);
        return result;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slotId);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemInSlot = clickedSlot.func_75211_c();
        if (itemInSlot == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = itemInSlot.func_77946_l();
        if (slotId > 9 && slotId < 39 ? !this.func_75135_a(itemInSlot, 39, this.field_75151_b.size(), true) : slotId > 38 && slotId < this.field_75151_b.size() && !this.func_75135_a(itemInSlot, 10, 37, false)) {
            return ItemStack.field_190927_a;
        }
        if (itemInSlot.func_190916_E() == 0) {
            clickedSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            clickedSlot.func_75218_e();
        }
        if (itemInSlot.func_190916_E() == returnStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return returnStack;
    }

    public void func_75130_a(@Nullable IInventory inventory) {
        if (this.invPlayer.field_70458_d instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this.invPlayer.field_70458_d;
            this.bench.onCraftMatrixChanged(this.craftMatrix);
            ICraftingRecipe recipe = this.bench.getRecipe(this.craftMatrix, 0);
            ItemStack stack = ItemStack.field_190927_a;
            if (recipe != null && this.craftResult.func_201561_a(serverplayerentity.field_70170_p, serverplayerentity, (IRecipe)recipe)) {
                stack = recipe.func_77572_b((IInventory)this.craftMatrix);
            }
            this.craftResult.func_70299_a(0, stack);
            this.bench.setCraftResult(stack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 9, stack));
        }
    }

    private static class ContainerNoInteract
    extends Container {
        protected ContainerNoInteract() {
            super(null, 0);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }
    }

    public static class GhostMatrixCrafting
    extends CraftingInventory {
        private final IInventory inventory;

        public GhostMatrixCrafting(IInventory inventory) {
            super((Container)new ContainerNoInteract(), 3, 3);
            this.inventory = inventory;
        }

        public int func_70297_j_() {
            return 1;
        }

        public ItemStack func_70301_a(int slotId) {
            return this.inventory.func_70301_a(slotId);
        }

        public void func_70299_a(int slotId, ItemStack itemStack) {
            this.inventory.func_70299_a(slotId, itemStack);
        }

        public ItemStack func_70298_a(int slotId, int amount) {
            return this.inventory.func_70298_a(slotId, amount);
        }
    }

    public static class SlotGhostCrafting
    extends CraftingResultSlot {
        private ContainerCraftBench container;

        public SlotGhostCrafting(PlayerEntity player, CraftingInventory craftMatrix) {
            super(player, craftMatrix, (IInventory)new CraftResultInventory(), 0, 128, 16);
        }

        SlotGhostCrafting(ContainerCraftBench container, int slotId, int posX, int posY) {
            super(((ContainerCraftBench)container).invPlayer.field_70458_d, (CraftingInventory)container.craftMatrix, (IInventory)container.craftResult, slotId, posX, posY);
            this.container = container;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return this.container.bench.ghostCraftCanTakeStack();
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            this.container.bench.ghostCraftOnPickupFromSlot(player, stack);
            this.container.func_75142_b();
            this.container.func_75130_a((IInventory)this.container.craftMatrix);
            return stack;
        }

        public void onPlayerCrafting(ItemStack stack) {
            this.func_75210_a(stack, stack.func_190916_E());
        }
    }
}

