/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.inventory;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;

public class ContainerEnderTable
extends Container {
    private static final ResourceLocation TAG_ENDER_DUST = new ResourceLocation("forge:dusts/ender_pearl");
    private final IInventory tableInventory = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerEnderTable.this.func_75130_a((IInventory)this);
        }
    };
    private final Random random = new Random();
    private final IntReferenceHolder xpSeed = IntReferenceHolder.func_221492_a();
    public final int[] experienceCost = new int[3];
    public final int[] enchantIds = new int[]{-1, -1, -1};
    public final int[] worldClue = new int[]{-1, -1, -1};
    public final int[] materialCost = new int[3];
    public String[] tooltips = new String[3];
    private final IntReferenceHolder refreshFlag = IntReferenceHolder.func_221492_a();
    private final World world;
    private final BlockPos pos;
    private final PlayerEntity player;

    public ContainerEnderTable(int id, PlayerInventory invPlayer, TileEntityEnderTable tile) {
        super(Values.Container.ENDERTABLE, id);
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.player = invPlayer.field_70458_d;
        this.func_75146_a(new SlotSingle(this.tableInventory, 0, 18, 41));
        this.func_75146_a(new Slot(this.tableInventory, 1, 38, 41));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)invPlayer, col + row * 9 + 9, 11 + col * 18, 86 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)invPlayer, col, 11 + col * 18, 144));
        }
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.experienceCost, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.experienceCost, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.experienceCost, (int)2));
        this.func_216958_a(this.xpSeed).func_221494_a(invPlayer.field_70458_d.func_175138_ci());
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantIds, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantIds, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantIds, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.materialCost, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.materialCost, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.materialCost, (int)2));
        this.func_216958_a(this.refreshFlag).func_221494_a(TriState.KEEP.ordinal());
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 13) {
            if (data == TriState.CLEAR.ordinal()) {
                this.tooltips[0] = "";
                this.tooltips[1] = "";
                this.tooltips[2] = "";
            } else {
                float enchantPower = this.getTotalEnchantPower();
                EnderTableRecipeHandler.RecipeSet recipes = EnderTableRecipeHandler.INSTANCE.getRecipes(this.tableInventory.func_70301_a(0), this.tableInventory.func_70301_a(1), enchantPower, this.world);
                for (int index = 0; index < 3; ++index) {
                    this.tooltips[index] = EnderTableRecipeHandler.INSTANCE.getTooltip(recipes.get(index), this.tableInventory.func_70301_a(0), this.tableInventory.func_70301_a(1), IEnderTableRecipe.EnumOption.byIndex(index));
                }
            }
        }
    }

    public void func_75130_a(IInventory inventory) {
        for (int index = 0; index < 3; ++index) {
            this.experienceCost[index] = 0;
            this.materialCost[index] = index + 1;
            this.enchantIds[index] = -1;
            this.worldClue[index] = -1;
        }
        this.refreshFlag.func_221494_a(TriState.CLEAR.ordinal());
        this.func_75142_b();
        if (inventory == this.tableInventory) {
            ItemStack enchantStack = inventory.func_70301_a(0);
            ItemStack materialStack = inventory.func_70301_a(1);
            if (!enchantStack.func_190926_b()) {
                float enchantPower = this.getTotalEnchantPower();
                EnderTableRecipeHandler.RecipeSet recipes = EnderTableRecipeHandler.INSTANCE.getRecipes(enchantStack, materialStack, enchantPower, this.world);
                if (EnderTableRecipeHandler.INSTANCE.hasAnyEnchantResult(recipes, enchantStack, materialStack)) {
                    for (int index = 0; index < 3; ++index) {
                        IEnderTableRecipe.EnumOption option = IEnderTableRecipe.EnumOption.byIndex(index);
                        this.experienceCost[index] = EnderTableRecipeHandler.INSTANCE.getExpCost(recipes.get(index), enchantStack, materialStack, option);
                        this.materialCost[index] = EnderTableRecipeHandler.INSTANCE.getMaterialCost(recipes.get(index), enchantStack, materialStack, option);
                    }
                    this.refreshFlag.func_221494_a(TriState.UPDATE.ordinal());
                    this.func_75142_b();
                } else if (enchantStack.func_77956_u()) {
                    if (!materialStack.func_190926_b() && materialStack.func_77973_b() == Items.field_151065_br) {
                        if (!this.player.field_71075_bZ.field_75098_d) {
                            materialStack.func_190918_g(1);
                        }
                        this.player.func_192024_a(ItemStack.field_190927_a, 0);
                        this.xpSeed.func_221494_a(this.player.func_175138_ci());
                        Function.giveItem((PlayerEntity)this.player, (ItemStack)materialStack);
                        inventory.func_70299_a(1, ItemStack.field_190927_a);
                    }
                    if (!this.world.field_72995_K) {
                        int set;
                        this.random.setSeed(this.xpSeed.func_221495_b());
                        for (set = 0; set < 3; ++set) {
                            this.experienceCost[set] = EnchantmentHelper.func_77514_a((Random)this.random, (int)set, (int)((int)enchantPower), (ItemStack)enchantStack);
                            this.enchantIds[set] = -1;
                            this.worldClue[set] = -1;
                            if (this.experienceCost[set] < set + 1) {
                                this.experienceCost[set] = 0;
                            }
                            this.experienceCost[set] = ForgeEventFactory.onEnchantmentLevelSet((World)this.world, (BlockPos)this.pos, (int)set, (int)((int)enchantPower), (ItemStack)enchantStack, (int)this.experienceCost[set]);
                        }
                        for (set = 0; set < 3; ++set) {
                            if (this.experienceCost[set] <= 0) continue;
                            List<EnchantmentData> list = this.getEnchantments(enchantStack, set, this.experienceCost[set]);
                            if (list != null && !list.isEmpty()) {
                                EnchantmentData enchantment = list.get(this.random.nextInt(list.size()));
                                this.enchantIds[set] = Registry.field_212628_q.func_148757_b((Object)enchantment.field_76302_b);
                                this.worldClue[set] = enchantment.field_76303_c;
                                continue;
                            }
                            this.experienceCost[set] = 0;
                            this.enchantIds[set] = -1;
                            this.worldClue[set] = -1;
                        }
                        this.refreshFlag.func_221494_a(TriState.UPDATE.ordinal());
                        this.func_75142_b();
                    }
                }
            }
        }
    }

    private float getTotalEnchantPower() {
        float enchantPower = 0.0f;
        for (int scanZ = -1; scanZ <= 1; ++scanZ) {
            for (int scanX = -1; scanX <= 1; ++scanX) {
                for (int scanY = 0; scanY < 3; ++scanY) {
                    if (scanZ == 0 && scanX == 0 || !this.world.func_175623_d(this.pos.func_177982_a(scanX, scanY, scanZ))) continue;
                    enchantPower += this.getEnchantPower(this.world, this.pos.func_177982_a(scanX * 2, scanY, scanZ * 2));
                    if (scanX == 0 || scanZ == 0) continue;
                    enchantPower += this.getEnchantPower(this.world, this.pos.func_177982_a(scanX * 2, scanY, scanZ));
                    enchantPower += this.getEnchantPower(this.world, this.pos.func_177982_a(scanX, scanY, scanZ * 2));
                }
            }
        }
        return enchantPower;
    }

    private float getEnchantPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public boolean func_75140_a(PlayerEntity player, int index) {
        List<EnchantmentData> listEnchants;
        IEnderTableRecipe.EnumOption option;
        float enchantPower;
        ItemStack dustStack;
        ItemStack enchantStack = this.tableInventory.func_70301_a(0);
        IEnderTableRecipe recipe = EnderTableRecipeHandler.INSTANCE.getRecipe(enchantStack, dustStack = this.tableInventory.func_70301_a(1), enchantPower = this.getTotalEnchantPower(), option = IEnderTableRecipe.EnumOption.byIndex(index), this.world);
        ItemStack result = EnderTableRecipeHandler.INSTANCE.getEnchantResult(recipe, enchantStack, dustStack, option);
        if (!result.func_190926_b()) {
            enchantStack = result;
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_192024_a(enchantStack, this.experienceCost[index]);
                if (!dustStack.func_190926_b()) {
                    dustStack.func_190918_g(this.materialCost[index]);
                }
            }
            this.tableInventory.func_70299_a(0, enchantStack);
            if (dustStack.func_190926_b()) {
                this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
            } else {
                this.tableInventory.func_70299_a(1, dustStack);
            }
            EnderTableRecipeHandler.INSTANCE.doneEnchant(recipe, enchantStack, dustStack, enchantPower, option, this.world);
            return true;
        }
        int cost = index + 1;
        if ((dustStack.func_190926_b() || dustStack.func_190916_E() < cost) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.experienceCost[index] <= 0 || enchantStack.func_190926_b() || (player.field_71068_ca < cost || player.field_71068_ca < this.experienceCost[index]) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!this.world.field_72995_K && (listEnchants = this.getEnchantments(enchantStack, index, this.experienceCost[index])) != null) {
            boolean isBook;
            player.func_192024_a(enchantStack, cost);
            boolean bl = isBook = enchantStack.func_77973_b() == Items.field_151122_aG;
            if (isBook) {
                enchantStack = new ItemStack((IItemProvider)Items.field_151134_bR);
                this.tableInventory.func_70299_a(0, enchantStack);
            }
            for (EnchantmentData enchantment : listEnchants) {
                if (isBook) {
                    EnchantedBookItem.func_92115_a((ItemStack)enchantStack, (EnchantmentData)enchantment);
                    continue;
                }
                enchantStack.func_77966_a(enchantment.field_76302_b, enchantment.field_76303_c);
            }
            if (!player.field_71075_bZ.field_75098_d && !dustStack.func_190926_b()) {
                dustStack.func_190918_g(cost);
                if (dustStack.func_190926_b()) {
                    this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
                }
            }
            player.func_195066_a(Stats.field_188091_Y);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_192129_i.func_192190_a((ServerPlayerEntity)player, enchantStack, cost);
            }
            this.tableInventory.func_70296_d();
            this.xpSeed.func_221494_a(player.func_175138_ci());
            this.func_75130_a(this.tableInventory);
            this.world.func_184133_a(null, this.pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, this.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    private List<EnchantmentData> getEnchantments(ItemStack stack, int index, int level) {
        this.random.setSeed(this.xpSeed.func_221495_b() + index);
        List list = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)stack, (int)level, (boolean)false);
        if (stack.func_77973_b() == Items.field_151122_aG && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasMaterialNeeded(int index) {
        if (this.materialCost[index] < 1) {
            return true;
        }
        ItemStack stack = this.tableInventory.func_70301_a(1);
        if (stack.func_190926_b() || this.materialCost[index] > stack.func_190916_E()) {
            return false;
        }
        if (this.enchantIds[index] > -1) {
            return stack.func_77973_b().getTags().contains(TAG_ENDER_DUST);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<EnchantmentData> getEnchantments(int index, int level) {
        return this.getEnchantments(this.tableInventory.func_70301_a(0), index, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_217005_f() {
        return this.xpSeed.func_221495_b();
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.func_193327_a(player, player.field_70170_p, this.tableInventory);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.world.func_180495_p(this.pos).func_177230_c() == Values.blockEnderTable && player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack rStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack sStack = slot.func_75211_c();
            rStack = sStack.func_77946_l();
            boolean nullify = false;
            if (index == 0 || index == 1) {
                if (!this.func_75135_a(sStack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!((Slot)this.field_75151_b.get(0)).func_75216_d()) {
                if (sStack.func_190916_E() == 1) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(sStack.func_77946_l());
                    sStack.func_190920_e(0);
                } else if (sStack.func_190916_E() >= 1) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(sStack.func_77979_a(1));
                    nullify = true;
                }
            } else if (!((Slot)this.field_75151_b.get(1)).func_75216_d() && sStack.func_77973_b() == Items.field_151065_br && ((Slot)this.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_75151_b.get(0)).func_75211_c().func_77956_u()) {
                if (sStack.func_190916_E() == 1) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(sStack.func_77946_l());
                    sStack.func_190920_e(0);
                } else if (sStack.func_190916_E() >= 1) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(sStack.func_77979_a(1));
                    nullify = true;
                }
            } else if (!this.func_75135_a(sStack, 1, 2, true)) {
                return ItemStack.field_190927_a;
            }
            if (sStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (nullify || sStack.func_190916_E() == rStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, sStack);
        }
        return rStack;
    }

    private static class SlotSingle
    extends Slot {
        public SlotSingle(IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int func_75219_a() {
            return 1;
        }
    }

    private static enum TriState {
        CLEAR,
        KEEP,
        UPDATE;

    }
}

