/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.client.render.RenderRegistry;

public class ItemBlockVine
extends BlockItem
implements IColored {
    private final PlantAPI.PlantType plantType;

    public ItemBlockVine(PlantAPI.PlantType plantType, Block block, Item.Properties builder) {
        super(block, builder);
        this.plantType = plantType;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.COLORIZE.add((Object)this);
            RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"has_fruit", (stack, world, entity) -> ItemBlockVine.hasFruit(stack) ? 1.0f : 0.0f));
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            list.add((Object)ItemBlockVine.create(this.plantType, true));
        }
    }

    public static ItemStack create(PlantAPI.PlantType plantType, boolean withFruit) {
        ItemStack stack;
        Block block = Values.blockPlants.get((Object)plantType);
        if (block != null && !(stack = new ItemStack((IItemProvider)block)).func_190926_b()) {
            if (withFruit) {
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_74757_a("has_fruit", true);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public PlantAPI.PlantType getPlantType() {
        return this.plantType;
    }

    public static boolean hasFruit(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74764_b("has_fruit") && nbt.func_74767_n("has_fruit");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 1) {
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.plantType));
        }
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        if (ItemBlockVine.hasFruit(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.withfruit.txt")));
        }
    }
}

