/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketBolt;

public class ItemHammer
extends Item
implements IStormForgeStackHandler {
    private static final ToolType WRENCH = ToolType.get((String)"wrench");
    private static final ToolType HAMMER = ToolType.get((String)"hammer");
    private static final short maxCharge = 25;

    public ItemHammer(Item.Properties builder) {
        super(builder);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)this, (Object)"mode", (stack, world, entity) -> this.getCharge(stack) > 0 ? 1.0f : 0.0f)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            this.addCharge(stack, 0);
            list.add((Object)stack.func_77946_l());
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    private void addCharge(ItemStack stack, int value) {
        int charge = this.getCharge(stack) + value;
        stack.func_196082_o().func_74777_a("charge", (short)MathHelper.func_76125_a((int)charge, (int)0, (int)25));
    }

    private short getCharge(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("charge")) {
            nbt.func_74777_a("charge", (short)0);
        }
        return (short)MathHelper.func_76125_a((int)nbt.func_74765_d("charge"), (int)0, (int)25);
    }

    private void useCharge(ItemStack stack) {
        this.addCharge(stack, -1);
    }

    public int getHarvestLevel(ItemStack stack, ToolType toolType, PlayerEntity player, BlockState state) {
        return toolType == WRENCH || toolType == HAMMER ? 1 : -1;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Rotation direction = player != null && player.func_213453_ef() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState result = state.rotate((IWorld)world, pos, direction);
        if (player != null) {
            player.func_184609_a(context.func_221531_n());
        }
        if (result != state) {
            state = world.func_180495_p(pos);
            if (result != state) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)result, (boolean)true);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.getCharge(stack) > 0 ? Rarity.EPIC : super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getCharge(stack) > 0 ? 1.0 - (double)this.getCharge(stack) / 25.0 : 0.0;
    }

    @Override
    public boolean handleStack(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack processStack(ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            StormForgeHelper.spawnLighting((ServerWorld)world, pos, false);
        }
        StormForgeHelper.moveFire(world, pos);
        this.addCharge(stack, 25);
        return stack;
    }

    @Override
    public boolean isFinished(ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        return true;
    }

    @Override
    public int ticksToComplete(ItemStack stack) {
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getCharge(stack) > 0) {
            player.func_184609_a(hand);
            Vector3d end = null;
            Entity entityInFront = Function.getLivingEntityInFront((World)world, (Entity)player, (double)50.0);
            if (entityInFront != null) {
                end = entityInFront.func_213303_ch();
            } else {
                Function.BlockInfo info = Function.getBlockInfront((World)world, (Entity)player, (double)50.0, (boolean)false);
                if (info != null) {
                    BlockPos firePos = info.pos.func_177972_a(info.face);
                    Vector3d vector3d = end = world.func_175623_d(firePos) ? info.vec : null;
                    if (!world.field_72995_K && world.field_73012_v.nextBoolean() && world.func_82736_K().func_223586_b(GameRules.field_223598_a) && Blocks.field_150480_ab.func_176223_P().func_196955_c((IWorldReader)world, firePos)) {
                        world.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            if (end != null) {
                if (!world.field_72995_K && world instanceof ServerWorld) {
                    Vector3d start = player.func_213303_ch().func_72441_c(0.0, (double)(player.func_70047_e() / 2.0f), 0.0);
                    PacketBolt packet = new PacketBolt(start, end, 0xFF80FF);
                    List entityList = world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, start.field_72450_a + 1.0, start.field_72448_b + 1.0, start.field_72449_c + 1.0).func_72321_a(16.0, 16.0, 16.0));
                    List entityList2 = world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(end.field_72450_a, end.field_72448_b, end.field_72449_c, end.field_72450_a + 1.0, end.field_72448_b + 1.0, end.field_72449_c + 1.0).func_72321_a(16.0, 16.0, 16.0));
                    for (ServerPlayerEntity entityPlayerMP : entityList2) {
                        if (entityList.contains(entityPlayerMP)) continue;
                        entityList.add(entityPlayerMP);
                    }
                    NetworkHandler.sendToList(packet, entityList);
                    world.func_184148_a(null, start.field_72450_a, start.field_72448_b, start.field_72449_c, Values.soundArc, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    world.func_184148_a(null, end.field_72450_a, end.field_72448_b, end.field_72449_c, Values.soundSpark, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    LightningBoltEntity passedBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                    passedBolt.func_233576_c_(end);
                    passedBolt.func_233623_a_(false);
                    List list = world.func_217357_a(Entity.class, new AxisAlignedBB(end.field_72450_a, end.field_72448_b, end.field_72449_c, end.field_72450_a + 1.0, end.field_72448_b + 1.0, end.field_72449_c + 1.0).func_72321_a(2.0, 2.0, 2.0));
                    for (Entity entity : list) {
                        if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)passedBolt)) continue;
                        entity.func_241841_a((ServerWorld)world, passedBolt);
                    }
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useCharge(stack);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity victim) {
        ItemStack extraModifiers = new ItemStack((IItemProvider)Items.field_151055_y);
        extraModifiers.func_77966_a(Enchantments.field_180313_o, this.getCharge(stack) > 0 ? 8 : 3);
        extraModifiers.func_77966_a(Enchantments.field_185302_k, 3);
        player.func_184185_a(Values.soundHammer, 1.0f, 1.0f);
        return ItemToolWithDamageSource.onLeftClickEntity((PlayerEntity)player, (Entity)victim, null, (ItemStack)extraModifiers);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + (this.getCharge(stack) > 0 ? ".activated" : "");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getCharge(stack) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.getCharge(stack) < 1) {
            tooltip.add(Localization.getTextComponent((String)"info.terraqueous.hammer.txt"));
        }
    }
}

