/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemMultiTool
extends ItemToolWithDamageSource
implements IToolMode {
    private static final HashMap<Integer, Integer> expMap = new HashMap();
    private static final ToolType toolTypeHoe = ToolType.get((String)"hoe");

    public ItemMultiTool(Item.Properties properties) {
        super(3.0f, -1.0f, (IItemTier)ItemTier.DIAMOND, Values.damageMultiTool, properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)this, (Object)"mode", (stack, world, entity) -> ItemMultiTool.getEnumType(stack).getValue())));
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78040_i || group == ItemGroup.field_78037_j || super.func_194125_a(group);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (super.func_194125_a(group)) {
            for (EnumType type : EnumType.values()) {
                list.add((Object)ItemMultiTool.newTool(type));
            }
        } else if (group == ItemGroup.field_78040_i) {
            list.add((Object)ItemMultiTool.newTool(EnumType.PICKAXE));
            list.add((Object)ItemMultiTool.newTool(EnumType.AXE));
            list.add((Object)ItemMultiTool.newTool(EnumType.SHOVEL));
            list.add((Object)ItemMultiTool.newTool(EnumType.HOE));
        } else if (group == ItemGroup.field_78037_j) {
            list.add((Object)ItemMultiTool.newTool(EnumType.WEAPON));
        }
    }

    public static ItemStack newTool(EnumType type) {
        ItemStack stack = new ItemStack((IItemProvider)Values.itemMultiTool);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("tool", type.toString());
        if (type == EnumType.BROKEN) {
            stack.func_196085_b(stack.func_77958_k());
        }
        return stack;
    }

    public static EnumType getEnumType(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("tool")) {
            nbt.func_74778_a("tool", EnumType.PICKAXE.toString());
        }
        return EnumType.byName(nbt.func_74779_i("tool"));
    }

    private ItemStack setType(ItemStack stack, EnumType type) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("tool", type.toString());
        return stack;
    }

    @Override
    public boolean changeMode(PlayerEntity player, ItemStack stack, boolean next) {
        EnumType type;
        if (stack != null && stack.func_77973_b() instanceof ItemMultiTool && (type = ItemMultiTool.getEnumType(stack)) != EnumType.BROKEN) {
            int value = type.getValue() + (next ? -1 : 1);
            this.setType(stack, EnumType.byValue(value));
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + ItemMultiTool.getEnumType(stack).toString();
    }

    private Item getToolTypeItem(ItemStack stack) {
        switch (ItemMultiTool.getEnumType(stack)) {
            case AXE: {
                return Items.field_151056_x;
            }
            case HOE: {
                return Items.field_151012_L;
            }
            case PICKAXE: {
                return Items.field_151046_w;
            }
            case SHOVEL: {
                return Items.field_151047_v;
            }
            case WEAPON: {
                return Items.field_151048_u;
            }
        }
        return Items.field_151055_y;
    }

    private ItemStack getToolTypeStack(ItemStack stack) {
        return new ItemStack((IItemProvider)this.getToolTypeItem(stack));
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.getToolTypeItem(stack).func_150897_b(state);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        ItemStack tool = this.getToolTypeStack(stack);
        return tool.func_77973_b().func_150893_a(tool, state) * 1.5f;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        ItemStack tool = this.getToolTypeStack(stack);
        Set toolTypes = tool.func_77973_b().getToolTypes(tool);
        if (tool.func_77973_b() instanceof HoeItem && !toolTypes.contains(toolTypeHoe)) {
            HashSet<ToolType> set = new HashSet<ToolType>(toolTypes);
            set.add(toolTypeHoe);
            return set;
        }
        return toolTypes;
    }

    public int func_77619_b() {
        return ItemTier.IRON.func_200927_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (!repair.func_190926_b()) {
            Item item = repair.func_77973_b();
            for (ResourceLocation location : item.getTags()) {
                String path;
                if (!location.func_110624_b().equals("forge") || !(path = location.func_110623_a()).equals("ingots/iron") && !path.equals("gems/burnium") && !path.equals("gems/endimium")) continue;
                return true;
            }
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return this.getToolTypeStack(stack).func_111283_C(slot);
    }

    public int getHarvestLevel(ItemStack stack, ToolType toolType, PlayerEntity player, BlockState state) {
        ItemStack tool = this.getToolTypeStack(stack);
        return tool.func_77973_b().getHarvestLevel(tool, toolType, player, state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand;
        ItemStack heldItem;
        ActionResultType toolResult = ActionResultType.PASS;
        PlayerEntity player = context.func_195999_j();
        if (player != null && !(heldItem = player.func_184586_b(hand = context.func_221531_n())).func_190926_b()) {
            ItemStack tool = this.getToolTypeStack(heldItem);
            Direction direction = context.func_196000_l();
            BlockPos pos = context.func_195995_a().func_177972_a(direction.func_176734_d());
            if (player.func_213453_ef() || ItemMultiTool.getEnumType(heldItem) == EnumType.AXE) {
                toolResult = tool.func_77973_b().func_195939_a((ItemUseContext)new UseContext(context.func_195991_k(), player, hand, tool, Function.fakeMOP((BlockPos)pos, (Direction)direction)));
            } else {
                BlockPos.Mutable sPos = new BlockPos.Mutable();
                for (int row = -1; row < 2; row = (int)((byte)(row + 1))) {
                    for (int col = -1; col < 2; col = (int)((byte)(col + 1))) {
                        if (row == 0 && col == 0) {
                            sPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        } else {
                            switch (direction) {
                                case DOWN: 
                                case UP: {
                                    sPos.func_181079_c(pos.func_177958_n() + row, pos.func_177956_o(), pos.func_177952_p() + col);
                                    break;
                                }
                                case NORTH: 
                                case SOUTH: {
                                    sPos.func_181079_c(pos.func_177958_n() + row, pos.func_177956_o() + col, pos.func_177952_p());
                                    break;
                                }
                                case EAST: 
                                case WEST: {
                                    sPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + row, pos.func_177952_p() + col);
                                }
                            }
                        }
                        ActionResultType resultType = tool.func_77973_b().func_195939_a((ItemUseContext)new UseContext(context.func_195991_k(), player, hand, tool, Function.fakeMOP((BlockPos)sPos, (Direction)direction)));
                        if (!resultType.func_226246_a_()) continue;
                        toolResult = ActionResultType.SUCCESS;
                    }
                }
            }
        }
        return toolResult;
    }

    public float getBreakSpeed(ItemStack stack, PlayerEntity player, BlockState state, float original, BlockPos pos) {
        World world = player.func_130014_f_();
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.PICKAXE || type == EnumType.SHOVEL) {
            if (player.func_213453_ef() || !this.isToolEffective(world, pos, world.func_180495_p(pos), stack, player)) {
                return original;
            }
            List<BlockPos> blockPosList = this.getBlocksToHarvest(stack, player, pos);
            if (blockPosList.isEmpty()) {
                return original;
            }
            float baseHardness = state.func_185887_b((IBlockReader)world, pos);
            float blockSpeed = original;
            float blockHardness = baseHardness;
            for (BlockPos sPos : blockPosList) {
                BlockState sState = world.func_180495_p(sPos);
                blockSpeed += player.getDigSpeed(sState, sPos);
                blockHardness += sState.func_185887_b((IBlockReader)world, sPos);
            }
            return blockSpeed / blockHardness * baseHardness / ((float)blockPosList.size() * 0.75f);
        }
        return original;
    }

    private List<BlockPos> getBlocksToHarvest(ItemStack stack, PlayerEntity player, BlockPos pos) {
        ArrayList<BlockPos> blockPosList;
        block12: {
            BlockPos.Mutable sPos;
            World world;
            block11: {
                world = player.func_130014_f_();
                blockPosList = new ArrayList<BlockPos>();
                sPos = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (ItemMultiTool.getEnumType(stack) != EnumType.AXE) break block11;
                ArrayList<Long> processed = new ArrayList<Long>();
                ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
                queue.add(pos);
                while (!queue.isEmpty() && blockPosList.size() <= 512) {
                    BlockPos qPos = (BlockPos)queue.peekFirst();
                    for (int x = -1; x < 2; x = (int)((byte)(x + 1))) {
                        for (int z = -1; z < 2; z = (int)((byte)(z + 1))) {
                            for (int y = -1; y < 2; y = (int)((byte)(y + 1))) {
                                if (x == 0 && y == 0 && z == 0) continue;
                                sPos.func_181079_c(qPos.func_177958_n() + x, qPos.func_177956_o() + y, qPos.func_177952_p() + z);
                                Long sl = sPos.func_218275_a();
                                if (processed.contains(sl)) continue;
                                processed.add(sl);
                                if (!player.func_175151_a((BlockPos)sPos, Direction.UP, stack) || world.func_175623_d((BlockPos)sPos) || !BlockTags.field_200031_h.func_230235_a_((Object)world.func_180495_p((BlockPos)sPos).func_177230_c())) continue;
                                blockPosList.add(sPos.func_185334_h());
                                queue.add(sPos.func_185334_h());
                            }
                        }
                    }
                    queue.removeFirst();
                }
                break block12;
            }
            BlockRayTraceResult mop = ItemMultiTool.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (!(mop instanceof BlockRayTraceResult)) break block12;
            Direction facing = mop.func_216354_b();
            for (int row = -1; row < 2; row = (int)((byte)(row + 1))) {
                block10: for (int col = -1; col < 2; col = (int)((byte)(col + 1))) {
                    if (row == 0 && col == 0) continue;
                    switch (facing) {
                        case DOWN: 
                        case UP: {
                            sPos.func_181079_c(pos.func_177958_n() + row, pos.func_177956_o(), pos.func_177952_p() + col);
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            sPos.func_181079_c(pos.func_177958_n() + row, pos.func_177956_o() + col, pos.func_177952_p());
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            sPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + row, pos.func_177952_p() + col);
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    if (!player.func_175151_a((BlockPos)sPos, facing, stack) || world.func_175623_d((BlockPos)sPos) || !this.isToolEffective(world, (BlockPos)sPos, player.func_130014_f_().func_180495_p((BlockPos)sPos), stack, player)) continue;
                    blockPosList.add(sPos.func_185334_h());
                }
            }
        }
        return blockPosList;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.BROKEN) {
            return false;
        }
        float baseHardness = state.func_185887_b((IBlockReader)world, pos);
        if ((double)baseHardness > 0.0) {
            stack.func_222118_a(1, entity, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
            stack.func_190920_e(1);
            super.setDamage(stack, this.getMaxDamage(stack) - 1);
        }
        if (type != EnumType.PICKAXE && type != EnumType.SHOVEL && type != EnumType.AXE || world.field_72995_K || !(entity instanceof ServerPlayerEntity)) {
            return true;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        if (player.func_213453_ef() || !this.isToolEffective(world, pos, world.func_180495_p(pos), stack, (PlayerEntity)player)) {
            return true;
        }
        List<BlockPos> blockPosList = this.getBlocksToHarvest(stack, (PlayerEntity)player, pos);
        if (!blockPosList.isEmpty()) {
            int counter = 1;
            for (BlockPos sPos : blockPosList) {
                int exp;
                if (ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
                    stack.func_190920_e(1);
                    super.setDamage(stack, this.getMaxDamage(stack) - 1);
                    break;
                }
                BlockState sState = world.func_180495_p(sPos);
                int sId = Block.func_196246_j((BlockState)sState);
                if (expMap.containsKey(sId)) {
                    exp = expMap.get(sId);
                } else {
                    exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)sPos);
                    expMap.put(sId, exp);
                }
                if (exp == -1) continue;
                if ((double)sState.func_185887_b((IBlockReader)world, sPos) > 0.0 && ++counter % 3 == 0) {
                    stack.func_222118_a(1, entity, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
                }
                TileEntity sTile = world.func_175625_s(sPos);
                if (player.field_71075_bZ.field_75098_d) {
                    this.removeBlock(world, sPos, (PlayerEntity)player, false);
                    continue;
                }
                boolean harvest = sState.canHarvestBlock((IBlockReader)world, sPos, (PlayerEntity)player);
                boolean removed = this.removeBlock(world, sPos, (PlayerEntity)player, harvest);
                if (removed && harvest) {
                    sState.func_177230_c().func_180657_a(world, (PlayerEntity)player, sPos, sState, sTile, stack.func_77946_l());
                }
                if (!removed || exp <= 0 || !(world instanceof ServerWorld)) continue;
                state.func_177230_c().func_180637_b((ServerWorld)world, sPos, exp);
            }
        }
        return true;
    }

    private boolean removeBlock(World world, BlockPos pos, PlayerEntity player, boolean canHarvest) {
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }

    private boolean isToolEffective(World world, BlockPos pos, BlockState state, ItemStack stack, PlayerEntity player) {
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        ItemStack tool = this.getToolTypeStack(stack);
        for (ToolType type : tool.getToolTypes()) {
            if (!(tool.func_150997_a(state) > 1.0f) || this.getHarvestLevel(stack, type, player, state) < state.getHarvestLevel()) continue;
            return true;
        }
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage < this.getDamage(stack) && ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
            this.setType(stack, EnumType.PICKAXE);
        }
        if (this.getMaxDamage(stack) - damage < 1) {
            damage = this.getMaxDamage(stack) - 1;
            this.setType(stack, EnumType.BROKEN);
        }
        super.setDamage(stack, damage);
    }

    protected float getBonusDamage(PlayerEntity player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        ItemStack stack = player.func_184614_ca();
        return bonusDamage + (!stack.func_190926_b() && stack.func_77973_b() == this && ItemMultiTool.getEnumType(stack) == EnumType.WEAPON ? damage / 3.0f : 0.0f);
    }

    protected void postHurtEntity(PlayerEntity player, Entity victim, MyDamageSource source) {
        EnumType type;
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_190926_b() || stack.func_77973_b() != this || (type = ItemMultiTool.getEnumType(stack)) != EnumType.WEAPON && type != EnumType.PICKAXE && type != EnumType.AXE)) {
            victim.func_70015_d(4);
        }
        super.postHurtEntity(player, victim, source);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.multitool.txt")));
    }

    public static enum EnumType {
        PICKAXE(0),
        SHOVEL(1),
        AXE(2),
        HOE(3),
        WEAPON(4),
        BROKEN(5);

        private static EnumType[] array;
        private static final Map<String, EnumType> map;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[value < 0 ? 4 : (value > 4 ? 0 : value)];
        }

        public static EnumType byName(String name) {
            name = name.toLowerCase().trim();
            return map.getOrDefault(name, PICKAXE);
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumType>();
            array = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
                map.put(value.toString(), value);
            }
        }
    }
}

