/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.common.item.ArmorMaterial;
import shetiphian.terraqueous.modintegration.curios.Curios_Base;

public class ItemToonTrotters
extends ArmorItem
implements ICapabilityProvider {
    @ObjectHolder(value="minecraft:feather_falling")
    private static Enchantment FEATHER_FALLING;

    public ItemToonTrotters(Item.Properties builder) {
        super((IArmorMaterial)ArmorMaterial.UTILITY, EquipmentSlotType.FEET, builder);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "terraqueous:textures/model/armor/toon_trotters.png";
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        ItemToonTrotters.checkFall(stack, (Entity)player);
    }

    public static void checkFall(ItemStack stack, Entity entity) {
        if (stack.func_190926_b() || entity.func_213322_ci().func_82617_b() >= 0.0) {
            return;
        }
        CompoundNBT tag = stack.func_190925_c("status");
        byte status = tag.func_74771_c("active_state");
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        boolean toonWalk = false;
        switch (status) {
            case 0: {
                if (!(entity.func_70051_ag() && entity.field_70125_A < 15.0f) && !(entity.field_70125_A < -15.0f)) break;
                BlockState state = world.func_180495_p(pos);
                toonWalk = state.func_185904_a().func_76224_d();
                if (!toonWalk) {
                    int counter = 0;
                    for (int scan = 0; scan < 2 && !ItemToonTrotters.isGround(world, pos, state); ++scan) {
                        ++counter;
                        pos = pos.func_177977_b();
                        state = world.func_180495_p(pos);
                    }
                    boolean bl = toonWalk = counter > 1;
                }
                if (!toonWalk) break;
                tag.func_74774_a("active_state", (byte)1);
                break;
            }
            case 1: {
                if (ItemToonTrotters.isGround(world, pos, null)) {
                    tag.func_74774_a("active_state", (byte)0);
                    break;
                }
                if (entity.func_213453_ef() || entity.field_70125_A > 30.0f) {
                    tag.func_74774_a("active_state", (byte)-1);
                    break;
                }
                toonWalk = true;
                break;
            }
            default: {
                if (!entity.func_233570_aj_()) break;
                tag.func_74774_a("active_state", (byte)0);
            }
        }
        if (toonWalk) {
            Vector3d motion = entity.func_213322_ci();
            entity.func_213293_j(motion.func_82615_a(), 0.0, motion.func_82616_c());
            entity.field_70143_R = 0.0f;
        }
    }

    private static boolean isGround(World world, BlockPos pos, BlockState state) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        return !state.func_185904_a().func_76224_d() && !state.func_185904_a().func_76222_j();
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return Items.field_151021_T.func_77619_b();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == FEATHER_FALLING;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return this;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> curio = Curios_Base.INSTANCE.getCapability(capability, "toon_trotters");
        if (curio.isPresent()) {
            return curio;
        }
        return LazyOptional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        Localization.multiLineTooltip((String)"info.terraqueous.toon_trotters.msg", tooltip);
    }
}

