/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockBurnium;
import shetiphian.terraqueous.common.block.BlockEndimium;
import shetiphian.terraqueous.common.crafting.CraftingHandler;
import shetiphian.terraqueous.common.crafting.Recipes;
import shetiphian.terraqueous.common.entity.ai.EntityAIEatGrassAndHay;
import shetiphian.terraqueous.common.entity.ai.EntityAIMoultFeather;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemScythe;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketEquipmentChange;
import shetiphian.terraqueous.common.potion.EffectDisplacement;

public class EventHandler {
    private static final ITag.INamedTag<Item> TAG_FODDER_ITEM = ItemTags.func_199901_a((String)"terraqueous:fodder");
    private static final Map<EntityType<?>, Boolean> EATS_GRASS = new HashMap();
    private final List<UUID> breakCache = new ArrayList<UUID>();
    private final Cache<ResourceLocation, Byte> errorCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @SubscribeEvent
    public void tagsUpdatedEvent(TagsUpdatedEvent event) {
        Configuration.CAN_PROCESS_TAGS = true;
        Configuration.processTagLists();
        Recipes.loadRecipes();
    }

    @SubscribeEvent
    public void villagerTradesEvent(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        if (profession == Roster.PROFESSIONS.GARDNER.get()) {
            Int2ObjectMap allTrades = event.getTrades();
            for (Block flower : Values.blockFlowers) {
                ((List)allTrades.get(1)).add(new BasicTrade(new ItemStack((IItemProvider)flower, 16), new ItemStack((IItemProvider)Items.field_151166_bC), 4, 4, 1.0f));
            }
            ((List)allTrades.get(2)).add(new BasicTrade(1, EventHandler.setColor(new ItemStack((IItemProvider)Values.blockSmallFlowerPot)), 5, 2));
            ((List)allTrades.get(2)).add(new BasicTrade(1, new ItemStack((IItemProvider)Blocks.field_150346_d, 32), 5, 2));
            ((List)allTrades.get(3)).add(new BasicTrade(1, EventHandler.setColor(new ItemStack((IItemProvider)Values.blockMediumFlowerPot)), 5, 2));
            ((List)allTrades.get(3)).add(new BasicTrade(1, new ItemStack((IItemProvider)Blocks.field_196658_i, 16), 5, 2));
            ((List)allTrades.get(4)).add(new BasicTrade(1, EventHandler.setColor(new ItemStack((IItemProvider)Values.blockLargeFlowerPot)), 5, 2));
            ((List)allTrades.get(4)).add(new BasicTrade(2, new ItemStack((IItemProvider)Blocks.field_196661_l, 8), 5, 2));
            ((List)allTrades.get(5)).add(new BasicTrade(2, new ItemStack((IItemProvider)Items.field_151119_aD, 8), 5, 2));
            ((List)allTrades.get(5)).add(new BasicTrade(2, new ItemStack((IItemProvider)Blocks.field_150391_bh, 4), 5, 2));
        }
    }

    private static ItemStack setColor(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockRGB ? RGB16StackHelper.setRGB16((ItemStack)stack, (short)((ItemBlockRGB)stack.func_77973_b()).getStartingIndex(stack)) : stack;
    }

    @SubscribeEvent
    public void wandererTradesEvent(WandererTradesEvent event) {
        List generic = event.getGenericTrades();
        List rare = event.getRareTrades();
        if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.CACTUS)) {
            generic.add(new BasicTrade(1, new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.CACTUS), 4), 8, 5));
        }
        if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.PINEAPPLE)) {
            generic.add(new BasicTrade(1, new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.PINEAPPLE), 4), 8, 5));
        }
        if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.GRAPEVINE)) {
            generic.add(new BasicTrade(1, new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.GRAPEVINE), 4), 8, 5));
        }
        if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.LIFEVINE)) {
            rare.add(new BasicTrade(2, new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.LIFEVINE), 2), 4, 20));
        }
        if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.DEATHVINE)) {
            rare.add(new BasicTrade(2, new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.DEATHVINE), 2), 4, 20));
        }
    }

    @SubscribeEvent
    public void farmLandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof VillagerEntity && ((Boolean)Configuration.TWEAKS.VILLAGER.disableVillagerTrample.get()).booleanValue() || entity instanceof LivingEntity && CloudAPI.hasCloudWalk((LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        ItemStack potionStack;
        AnimalEntity animal;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_233645_dx_().func_233779_a_(Values.attributeDeathFruitAddiction);
            player.func_233645_dx_().func_233779_a_(Values.attributeDeathFruitTimer);
        }
        if (entity instanceof ChickenEntity && ((Boolean)Configuration.TWEAKS.chickensMoult.get()).booleanValue()) {
            ChickenEntity chicken = (ChickenEntity)entity;
            chicken.field_70714_bg.func_75776_a(1, (Goal)new EntityAIMoultFeather((LivingEntity)chicken));
        }
        if (entity instanceof AnimalEntity && ((Boolean)Configuration.TWEAKS.addHayAITasks.get()).booleanValue() && this.doesEntityEatGrass(animal = (AnimalEntity)entity)) {
            animal.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)animal, 1.1, Ingredient.func_199805_a(TAG_FODDER_ITEM), false));
            animal.field_70714_bg.func_75776_a(5, (Goal)new EntityAIEatGrassAndHay((MobEntity)animal));
        }
        if (entity instanceof PotionEntity && !(potionStack = ((PotionEntity)entity).func_184543_l()).func_190926_b()) {
            List list = PotionUtils.func_185189_a((ItemStack)potionStack);
            for (EffectInstance instance : list) {
                Entity thrower;
                Effect effect = instance.func_188419_a();
                if (effect == Values.effectFireWater) {
                    thrower = ((PotionEntity)entity).func_234616_v_();
                    if (thrower == null) continue;
                    ((PotionEntity)entity).func_70186_c((double)thrower.field_70125_A, (double)thrower.field_70177_z, -10.0, 1.0f, 1.0f);
                    continue;
                }
                if (effect != Values.effectDisplacement || (thrower = ((PotionEntity)entity).func_234616_v_()) == null) continue;
                ((PotionEntity)entity).func_70186_c((double)thrower.field_70125_A, (double)thrower.field_70177_z, 0.0, 2.0f, 1.0f);
            }
        }
    }

    private boolean doesEntityEatGrass(AnimalEntity animal) {
        if (animal != null) {
            EntityType type = animal.func_200600_R();
            if (EATS_GRASS.containsKey(type)) {
                return EATS_GRASS.get(type);
            }
            try {
                GoalSelector selector = animal.field_70714_bg;
                if (selector != null) {
                    Field field = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
                    Set goals = (Set)field.get(selector);
                    for (PrioritizedGoal goal : goals) {
                        if (!(goal.func_220772_j() instanceof EatGrassGoal)) continue;
                        EATS_GRASS.put(type, true);
                        return true;
                    }
                    EATS_GRASS.put(type, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @SubscribeEvent
    public void furnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item.getRegistryName().func_110624_b().equals("terraqueous")) {
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).func_179223_d();
                if (block instanceof BlockBurnium) {
                    event.setBurnTime((block == Values.blockBurniumOre ? 30 : 100) * 200);
                }
            } else if (item == Values.itemBurniumGem) {
                event.setBurnTime(3000);
            } else if (item == Values.itemBurniumDust) {
                event.setBurnTime(2600);
            } else if (item == Values.itemCoalDust) {
                event.setBurnTime(1600);
            }
        }
    }

    @SubscribeEvent
    public void itemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        CraftingHandler.INSTANCE.onCrafting(event.getCrafting(), event.getInventory());
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (player != null && player.field_71075_bZ.field_75098_d && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemScythe) {
            if (stack.func_77973_b().onBlockStartBreak(stack, event.getPos(), player)) {
                return;
            }
            stack.func_179548_a(player.field_70170_p, event.getWorld().func_180495_p(event.getPos()), event.getPos(), player);
        }
    }

    @SubscribeEvent
    public void livingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        String key = event.getSlot().func_188450_d();
        if (entity instanceof PlayerEntity) {
            if (entity instanceof ServerPlayerEntity && entity.field_70170_p != null) {
                NetworkHandler.sendToPlayer(new PacketEquipmentChange(key, event.getFrom(), event.getTo()), (ServerPlayerEntity)entity);
            }
        } else {
            EventHandler.processLivingEquipmentChangeEvent(entity, key, event.getFrom(), event.getTo());
        }
    }

    public static void processLivingEquipmentChangeEvent(LivingEntity entity, String slotName, ItemStack sFrom, ItemStack sTo) {
        if (entity != null && entity.field_70170_p != null && entity instanceof PlayerEntity == entity.field_70170_p.field_72995_K) {
            boolean cwFrom = CloudAPI.isCloudWalkItem(sFrom);
            boolean cwTo = CloudAPI.isCloudWalkItem(sTo);
            if (cwFrom || cwTo) {
                String keyTo;
                String keyFrom = cwFrom ? slotName + ":" + sFrom.func_77973_b().getRegistryName() : "";
                String string = keyTo = cwTo ? slotName + ":" + sTo.func_77973_b().getRegistryName() : "";
                if (!keyTo.equals(keyFrom)) {
                    if (cwTo) {
                        CloudAPI.grantCloudWalk(entity, keyTo);
                    }
                    if (cwFrom) {
                        CloudAPI.revokeCloudWalk(entity, keyFrom);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void livingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            BlueFlowerHandler.INSTANCE.blueUpdate(player);
            DeathFruitHelper.onPlayerUpdate(player);
        }
    }

    @SubscribeEvent
    public void playerRightClickAir(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        if (Values.itemCloudStaff != null && stack.func_77973_b() == Values.itemCloudStaff) {
            Values.itemCloudStaff.func_195939_a(new ItemUseContext(player, event.getHand(), Function.fakeMOP((BlockPos)new BlockPos(0, -1, 0), (Direction)event.getFace())));
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof TallGrassBlock && player.func_213453_ef() && Values.blockDryingHay != null && Values.blockDryingHay.func_176223_P().func_196955_c((IWorldReader)event.getWorld(), event.getPos().func_177984_a())) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            Function.setBlock((IWorld)player.func_130014_f_(), (BlockPos)event.getPos().func_177984_a(), (BlockState)Values.blockDryingHay.func_176223_P(), (boolean)true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return;
        }
        if (!player.func_213453_ef()) {
            return;
        }
        if (block == Values.blockEnderTable && stack.func_77973_b() == Items.field_151122_aG) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            Function.setBlock((IWorld)event.getWorld(), (BlockPos)event.getPos(), (BlockState)Blocks.field_150381_bn.func_176223_P(), (boolean)true);
            Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Values.itemEnderBook));
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (block == Blocks.field_150381_bn && stack.func_77973_b() == Values.itemEnderBook) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            Function.setBlock((IWorld)event.getWorld(), (BlockPos)event.getPos(), (BlockState)Values.blockEnderTable.func_176223_P(), (boolean)true);
            Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Items.field_151122_aG));
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        AnimalEntity animal;
        PlayerEntity player = event.getPlayer();
        if (player == null || event.getTarget() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        Entity target = event.getTarget();
        if (!event.getWorld().field_72995_K && target instanceof AnimalEntity && TAG_FODDER_ITEM.func_230235_a_((Object)stack.func_77973_b()) && this.doesEntityEatGrass(animal = (AnimalEntity)target)) {
            boolean used = false;
            if (animal.func_110143_aJ() < animal.func_110138_aP()) {
                animal.func_70691_i(1.0f);
                used = true;
            } else if (animal.func_70631_g_()) {
                animal.func_175501_a((int)((float)(-animal.func_70874_b() / 20) * 0.1f), true);
                used = true;
            } else if (animal instanceof SheepEntity && ((SheepEntity)animal).func_70892_o()) {
                if (Function.random.nextInt(5) == 0) {
                    ((SheepEntity)animal).func_70893_e(false);
                }
                used = true;
            }
            if (used && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void livingDropsEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70631_g_() || !(entity.func_130014_f_() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)entity.func_130014_f_();
        if (world.func_82736_K().func_223586_b(GameRules.field_223602_e) && ((Boolean)Configuration.LOOT_TABLES.MOBS.enableMobDropTweaks.get()).booleanValue()) {
            PlayerEntity attacker;
            Collection dropList = event.getDrops();
            DamageSource source = event.getSource();
            PlayerEntity playerEntity = attacker = event.isRecentlyHit() && entity.func_94060_bK() instanceof PlayerEntity ? (PlayerEntity)entity.func_94060_bK() : null;
            if (entity instanceof BlazeEntity) {
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.blaze_BurniumDust.get()).booleanValue() && Values.itemBurniumDust != null) {
                    this.addDrops(dropList, "blaze_burnium_dust", entity, source, attacker);
                }
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.blaze_BurniumGem.get()).booleanValue() && Values.itemBurniumGem != null) {
                    this.addDrops(dropList, "blaze_burnium_gem", entity, source, attacker);
                }
            }
            if (entity instanceof EndermanEntity) {
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.enderman_EnderDust.get()).booleanValue() && Values.itemEnderDust != null) {
                    this.addDrops(dropList, "enderman_ender_dust", entity, source, attacker);
                }
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.enderman_EndimiumDust.get()).booleanValue() && Values.itemEndimiumDust != null) {
                    this.addDrops(dropList, "enderman_endimium_dust", entity, source, attacker);
                }
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.enderman_EndimiumGem.get()).booleanValue() && Values.itemEndimiumGem != null) {
                    this.addDrops(dropList, "enderman_endimium_gem", entity, source, attacker);
                }
            }
            if (entity instanceof EndermiteEntity) {
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.endermite_EnderDust.get()).booleanValue() && Values.itemEnderDust != null) {
                    this.addDrops(dropList, "endermite_ender_dust", entity, source, attacker);
                }
                if (((Boolean)Configuration.LOOT_TABLES.MOBS.endermite_EndimiumDust.get()).booleanValue() && Values.itemEndimiumDust != null) {
                    this.addDrops(dropList, "endermite_endimium_dust", entity, source, attacker);
                }
            }
            if (entity instanceof MagmaCubeEntity && ((Boolean)Configuration.LOOT_TABLES.MOBS.magmaCube_BurniumGem.get()).booleanValue() && Values.itemBurniumGem != null) {
                this.addDrops(dropList, "magma_cube_burnium_gem", entity, source, attacker);
            }
            if ((entity instanceof PiglinEntity || entity instanceof ZombifiedPiglinEntity) && ((Boolean)Configuration.LOOT_TABLES.MOBS.piglin_GoldDust.get()).booleanValue() && Values.itemGoldDust != null) {
                this.addDrops(dropList, "pigman_gold_dust", entity, source, attacker);
            }
            if (entity instanceof WitherSkeletonEntity && ((Boolean)Configuration.LOOT_TABLES.MOBS.witherSkeleton_CoalDust.get()).booleanValue() && Values.itemCoalDust != null) {
                this.addDrops(dropList, "wither_skeleton_coal_dust", entity, source, attacker);
            }
            if (entity instanceof ZombieEntity && ((Boolean)Configuration.LOOT_TABLES.MOBS.zombie_LeatherScraps.get()).booleanValue() && Values.itemLeatherScraps != null) {
                this.addDrops(dropList, "zombie_leather_scraps", entity, source, attacker);
            }
        }
    }

    public void addDrops(Collection<ItemEntity> dropList, String file, LivingEntity entity, DamageSource source, PlayerEntity attacker) {
        ServerWorld world = (ServerWorld)entity.func_130014_f_();
        Vector3d pos = entity.func_213303_ch();
        ResourceLocation location = new ResourceLocation("terraqueous", "loot_tables/inject/entities/" + file);
        LootTable lootTable = world.func_73046_m().func_200249_aQ().func_186521_a(location);
        LootContext.Builder context = new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)pos).func_216015_a(LootParameters.field_216283_c, (Object)source).func_216021_b(LootParameters.field_216284_d, (Object)source.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)source.func_76364_f());
        if (attacker != null) {
            context = context.func_216015_a(LootParameters.field_216282_b, (Object)attacker).func_186469_a(attacker.func_184817_da());
        }
        lootTable.func_216120_b(context.func_216022_a(LootParameterSets.field_216263_d), stack -> {
            if (!stack.func_190926_b()) {
                ItemEntity itemEntity = new ItemEntity((World)world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), stack);
                itemEntity.func_174869_p();
                dropList.add(itemEntity);
            }
        });
    }

    @SubscribeEvent
    public void lootTableLoadEvent(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        ResourceLocation resource = event.getName();
        switch (resource.toString()) {
            case "minecraft:chests/spawn_bonus_chest": {
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestSpawnBonus_LifeFruit.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/spawn_bonus_lifefruit", "lifefruit"));
                break;
            }
            case "minecraft:chests/abandoned_mineshaft": {
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestMineshaft_DeathFruit.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/mineshaft_deathfruit", "deathfruit"));
                break;
            }
            case "minecraft:chests/village/village_toolsmith": {
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestToolsmith_Colorizer.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/toolsmith_colorizer", "colorizer"));
                break;
            }
            case "minecraft:chests/simple_dungeon": {
                if (((Boolean)Configuration.LOOT_TABLES.CHESTS.chestDungeon_Colorizer.get()).booleanValue()) {
                    table.addPool(EventHandler.getInjectPool("chests/dungeon_colorizer", "colorizer"));
                }
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestDungeon_ToonTrotters.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/dungeon_toon_trotters", "toon_trotters"));
                break;
            }
            case "minecraft:chests/stronghold_library": {
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestStronghold_Scroll.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/stronghold_strange_scroll", "strange_scroll"));
                break;
            }
            case "minecraft:chests/nether_bridge": {
                if (!((Boolean)Configuration.LOOT_TABLES.CHESTS.chestNetherBridge_Scroll.get()).booleanValue()) break;
                table.addPool(EventHandler.getInjectPool("chests/nether_bridge_strange_scroll", "strange_scroll"));
            }
        }
    }

    private static LootPool getInjectPool(String file, String itemName) {
        return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("terraqueous:inject/" + file))).bonusRolls(0.0f, 1.0f).name("terraqueous_inject_" + itemName).func_216044_b();
    }

    @SubscribeEvent
    public void playerBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (player != null && !this.breakCache.contains(player.func_110124_au()) && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemMultiTool) {
            if (event.getPos() == null) {
                ResourceLocation blockId = null;
                try {
                    blockId = event.getState().func_177230_c().getRegistryName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (blockId != null) {
                    if (this.errorCache.getIfPresent((Object)blockId) == null) {
                        Terraqueous.LOGGER.error("A block is using the deprecated version of 'EntityPlayer.getDigSpeed', the MultiTool harvest speed will be wrong. Contact the mod author of " + blockId + " and ask them to use the correct method");
                    }
                    this.errorCache.put((Object)blockId, (Object)0);
                }
                event.setNewSpeed(event.getNewSpeed() + 250.0f);
            } else if (event.getPos().func_177956_o() > 0) {
                this.breakCache.add(player.func_110124_au());
                event.setNewSpeed(((ItemMultiTool)stack.func_77973_b()).getBreakSpeed(stack, player, event.getState(), event.getNewSpeed(), event.getPos()));
                this.breakCache.remove(player.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void throwableImpactEvent(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity throwable = event.getThrowable();
        if (throwable instanceof PotionEntity) {
            World world = throwable.func_130014_f_();
            BlockPos ePos = throwable.func_233580_cy_();
            if (!world.field_72995_K) {
                ItemStack potionStack = ((PotionEntity)throwable).func_184543_l();
                if (!potionStack.func_190926_b()) {
                    List list = PotionUtils.func_185189_a((ItemStack)potionStack);
                    for (EffectInstance instance : list) {
                        Effect effect = instance.func_188419_a();
                        if (effect == Values.effectFireWater) {
                            Stream blocks = BlockPos.func_218281_b((BlockPos)throwable.func_233580_cy_().func_177982_a(-2, -2, -2), (BlockPos)throwable.func_233580_cy_().func_177982_a(2, 1, 2));
                            blocks.forEach(pos -> {
                                double distance = ePos.func_218140_a((double)pos.func_177958_n(), (double)ePos.func_177956_o(), (double)pos.func_177952_p(), false);
                                if (distance < 6.0 && world.func_175623_d(pos) && Blocks.field_150480_ab.func_196260_a(world.func_180495_p(pos), (IWorldReader)world, pos)) {
                                    Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)Blocks.field_150480_ab.func_176223_P(), (boolean)true);
                                }
                            });
                            continue;
                        }
                        if (effect != Values.effectDisplacement) continue;
                        Entity thrower = throwable.func_234616_v_();
                        List entities = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(throwable.func_233580_cy_().func_177982_a(-5, -3, -5), throwable.func_233580_cy_().func_177982_a(5, 3, 5)));
                        for (LivingEntity entity : entities) {
                            if (thrower != null) {
                                entity.func_70634_a(thrower.func_226277_ct_(), thrower.func_226278_cu_(), thrower.func_226281_cx_());
                                continue;
                            }
                            BlockEndimium.teleportEntity(world, ePos, entity, 16);
                        }
                        if (!(thrower instanceof LivingEntity)) continue;
                        thrower.func_70634_a((double)ePos.func_177958_n(), (double)ePos.func_177956_o(), (double)ePos.func_177952_p());
                        EffectDisplacement.bottleSmash((LivingEntity)thrower, instance.func_76458_c());
                    }
                }
                if (((Boolean)Configuration.TWEAKS.enableGlassShardDropsForPotions.get()).booleanValue()) {
                    Function.dropItem((World)world, (BlockPos)ePos, (ItemStack)new ItemStack((IItemProvider)Values.itemGlassShard));
                }
            }
        }
    }
}

