/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.network;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import shetiphian.core.common.network.PacketBase;
import shetiphian.terraqueous.common.item.ItemColorizer;

public class PacketColorizer
extends PacketBase {
    private final byte preset;
    private final short rgbIndex;
    private final String name;

    public PacketColorizer(int preset, short rgbIndex, String name) {
        this.preset = (byte)preset;
        this.rgbIndex = rgbIndex;
        this.name = name;
    }

    public static void writeData(PacketColorizer packet, PacketBuffer buffer) {
        buffer.writeByte((int)packet.preset);
        buffer.writeShort((int)packet.rgbIndex);
        PacketColorizer.writeString((PacketBuffer)buffer, (String)packet.name.substring(0, Math.min(packet.name.length(), 32)));
    }

    public static PacketColorizer readData(PacketBuffer buffer) {
        return new PacketColorizer(buffer.readByte(), buffer.readShort(), PacketColorizer.readString((PacketBuffer)buffer));
    }

    public void handleClientSide(PlayerEntity player) {
    }

    public void handleServerSide(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
            ItemColorizer colorizer = (ItemColorizer)stack.func_77973_b();
            if (this.preset == -1) {
                colorizer.setRGB16(stack, this.rgbIndex);
            } else {
                colorizer.setRGB16Preset(stack, this.preset, this.rgbIndex, this.name);
            }
        }
    }
}

