/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFurnace;
import shetiphian.terraqueous.common.inventory.InventoryCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntityCloudFurnace
extends TileEntityAutoCrafting {
    private int smeltTime;
    private boolean isSmelting;
    private boolean lastIsSmelting;
    private short finishTime = (short)500;
    public final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityCloudFurnace.this.smeltTime;
                }
                case 1: {
                    return TileEntityCloudFurnace.this.finishTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityCloudFurnace.this.smeltTime = value;
                    break;
                }
                case 1: {
                    TileEntityCloudFurnace.this.finishTime = (short)value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public TileEntityCloudFurnace() {
        super(Values.tileCloudFurnace);
        this.inventory = new InventoryCloudFurnace(this);
        InventoryCloudFurnace inv = (InventoryCloudFurnace)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperInput(), inv.getWrapperOutput()});
        this.sidedWrapper.setFaceIndex(Direction.DOWN, 2);
        this.sidedWrapper.setFaceIndex(Direction.UP, 1);
        this.sidedWrapper.setFaceIndex(Direction.NORTH, 1);
        this.sidedWrapper.setFaceIndex(Direction.SOUTH, 1);
        this.sidedWrapper.setFaceIndex(Direction.WEST, 2);
        this.sidedWrapper.setFaceIndex(Direction.EAST, 1);
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("isSmelting", this.isSmelting);
    }

    @Override
    protected void buildNBT_SaveOnly(CompoundNBT nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        nbtTag.func_74768_a("smeltTime", this.smeltTime);
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.isSmelting = nbtTag.func_74767_n("isSmelting");
    }

    @Override
    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        this.smeltTime = nbtTag.func_74762_e("smeltTime");
    }

    protected void processNBT_SyncOnly(CompoundNBT nbtTag) {
        if (this.lastIsSmelting != this.isSmelting) {
            this.lastIsSmelting = this.isSmelting;
            Function.updateLighting((TileEntity)this);
        }
    }

    public void func_73660_a() {
        boolean inUse;
        boolean isItemSmeltable;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack stackInInput = this.inventory.func_70301_a(0);
        Triple<ItemStack, Float, Integer> result = this.getSmelted(stackInInput);
        boolean bl = isItemSmeltable = !((ItemStack)result.getLeft()).func_190926_b();
        if (!stackInInput.func_190926_b() && isItemSmeltable) {
            this.finishTime = (short)((double)((Integer)result.getRight()).intValue() * 2.5);
            ++this.smeltTime;
            if (this.func_145831_w().func_72896_J()) {
                ++this.smeltTime;
            }
            if (this.func_145831_w().func_72911_I()) {
                ++this.smeltTime;
            }
            if (this.smeltTime >= this.finishTime) {
                ItemStack output = (ItemStack)result.getLeft();
                ItemStack stackInOutput = this.inventory.func_70301_a(1);
                if (stackInOutput.func_190926_b() || this.canPlaceInSlot(stackInOutput, output, false)) {
                    this.addExperience(((Float)result.getMiddle()).floatValue());
                    if (!stackInOutput.func_190926_b()) {
                        stackInOutput.func_190917_f(output.func_190916_E());
                    } else {
                        this.inventory.func_70299_a(1, output);
                    }
                    stackInInput.func_190918_g(1);
                    if (stackInInput.func_190916_E() < 1) {
                        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
                    }
                    this.smeltTime = 0;
                    this.func_70296_d();
                }
            }
        }
        if (stackInInput.func_190926_b() && this.smeltTime > 0) {
            this.smeltTime = 0;
        }
        boolean bl2 = inUse = !stackInInput.func_190926_b() && isItemSmeltable && this.smeltTime < this.finishTime;
        if (this.isSmelting && !inUse || !this.isSmelting && inUse) {
            this.isSmelting = !this.isSmelting;
            Function.setBlock((IWorld)this.func_145831_w(), (BlockPos)this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)BlockFurnace.LIT, (Comparable)Boolean.valueOf(this.isSmelting))), (boolean)true);
        }
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int graphicWidth) {
        return this.smeltTime * graphicWidth / this.finishTime;
    }
}

