/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFurnace;
import shetiphian.terraqueous.common.inventory.InventoryCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntityCraftFurnace
extends TileEntityAutoCrafting {
    private int[] smeltTime = new int[2];
    private int burnTime;
    private int burnValue;
    public boolean isCloud;
    private boolean isSmelting;
    private boolean lastIsSmelting;
    private short[] finishTime;
    public final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityCraftFurnace.this.burnTime;
                }
                case 1: {
                    return TileEntityCraftFurnace.this.burnValue;
                }
                case 2: {
                    return TileEntityCraftFurnace.this.smeltTime[0];
                }
                case 3: {
                    return TileEntityCraftFurnace.this.smeltTime[1];
                }
                case 4: {
                    return TileEntityCraftFurnace.this.finishTime[0];
                }
                case 5: {
                    return TileEntityCraftFurnace.this.finishTime[1];
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityCraftFurnace.this.burnTime = value;
                    break;
                }
                case 1: {
                    TileEntityCraftFurnace.this.burnValue = value;
                    break;
                }
                case 2: {
                    ((TileEntityCraftFurnace)TileEntityCraftFurnace.this).smeltTime[0] = value;
                    break;
                }
                case 3: {
                    ((TileEntityCraftFurnace)TileEntityCraftFurnace.this).smeltTime[1] = value;
                    break;
                }
                case 4: {
                    ((TileEntityCraftFurnace)TileEntityCraftFurnace.this).finishTime[0] = (short)value;
                    break;
                }
                case 5: {
                    ((TileEntityCraftFurnace)TileEntityCraftFurnace.this).finishTime[1] = (short)value;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    };

    public TileEntityCraftFurnace(boolean isCloud) {
        super(isCloud ? Values.tileCloudCraftFurnace : Values.tileCraftFurnace);
        this.isCloud = isCloud;
        this.inventory = new InventoryCraftFurnace(this);
        InventoryCraftFurnace inv = (InventoryCraftFurnace)this.inventory;
        if (this.isCloud) {
            this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(true), inv.getWrapperItems(), inv.getWrapperOutput(true)});
            this.sidedWrapper.setFaceIndex(Direction.DOWN, 2);
            this.sidedWrapper.setFaceIndex(Direction.UP, 1);
            this.sidedWrapper.setFaceIndex(Direction.NORTH, 1);
            this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
            this.sidedWrapper.setFaceIndex(Direction.WEST, 1);
            this.sidedWrapper.setFaceIndex(Direction.EAST, 2);
            this.finishTime = new short[]{600, 600};
        } else {
            this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(false), inv.getWrapperItems(), inv.getWrapperFuel(), inv.getWrapperInputs(), inv.getWrapperOutput(false)});
            this.sidedWrapper.setFaceIndex(Direction.DOWN, 4);
            this.sidedWrapper.setFaceIndex(Direction.UP, 2);
            this.sidedWrapper.setFaceIndex(Direction.NORTH, 2);
            this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
            this.sidedWrapper.setFaceIndex(Direction.WEST, 1);
            this.sidedWrapper.setFaceIndex(Direction.EAST, 4);
            this.finishTime = new short[]{250, 250};
        }
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("isCloud", this.isCloud);
        nbtTag.func_74757_a("isSmelting", this.isSmelting);
    }

    @Override
    protected void buildNBT_SaveOnly(CompoundNBT nbtTag) {
        nbtTag.func_74783_a("smeltTime", this.smeltTime);
        nbtTag.func_74768_a("burnTime", this.burnTime);
        nbtTag.func_74768_a("burnValue", this.burnValue);
        super.buildNBT_SaveOnly(nbtTag);
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.func_74767_n("isCloud");
        this.isSmelting = nbtTag.func_74767_n("isSmelting");
    }

    @Override
    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        if (nbtTag.func_74764_b("smeltTime")) {
            this.smeltTime = nbtTag.func_74759_k("smeltTime");
        }
        this.burnTime = nbtTag.func_74762_e("burnTime");
        this.burnValue = nbtTag.func_74762_e("burnValue");
        if (nbtTag.func_74764_b("itemsFuel") || nbtTag.func_74764_b("itemsInput") || nbtTag.func_74764_b("itemsSmelt") || nbtTag.func_74764_b("itemsOutput")) {
            ItemStack[] itemsFuel = this.listReader(nbtTag.func_150295_c("itemsFuel", 10), 3);
            ItemStack[] itemsInput = this.listReader(nbtTag.func_150295_c("itemsInput", 10), 6);
            ItemStack[] itemsSmelt = this.listReader(nbtTag.func_150295_c("itemsSmelt", 10), 2);
            ItemStack[] itemsOutput = this.listReader(nbtTag.func_150295_c("itemsOutput", 10), 6);
            ItemStack[] contents = new ItemStack[17];
            System.arraycopy(itemsFuel, 0, contents, 0, 3);
            System.arraycopy(itemsInput, 0, contents, 3, 6);
            System.arraycopy(itemsSmelt, 0, contents, 9, 2);
            System.arraycopy(itemsOutput, 0, contents, 11, 6);
            ((InventoryCraftFurnace)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    protected void processNBT_SyncOnly(CompoundNBT nbtTag) {
        if (this.lastIsSmelting != this.isSmelting) {
            this.lastIsSmelting = this.isSmelting;
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean finalTick = false;
        if (this.burnTime > 0) {
            --this.burnTime;
            finalTick = this.burnTime == 0;
        }
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            ItemStack smeltStack = this.inventory.func_70301_a(9 + slotSmelt);
            if (!smeltStack.func_190926_b()) {
                Triple<ItemStack, Float, Integer> result;
                if (this.burnTime > 0 || this.isCloud || finalTick) {
                    int n = slotSmelt;
                    this.smeltTime[n] = this.smeltTime[n] + 1;
                    if (this.isCloud && this.func_145831_w().func_72896_J()) {
                        int n2 = slotSmelt;
                        this.smeltTime[n2] = this.smeltTime[n2] + 1;
                    }
                    if (this.isCloud && this.func_145831_w().func_72911_I()) {
                        int n3 = slotSmelt;
                        this.smeltTime[n3] = this.smeltTime[n3] + 1;
                    }
                }
                boolean isItemSmeltable = !((ItemStack)(result = this.getSmelted(smeltStack)).getLeft()).func_190926_b();
                this.finishTime[slotSmelt] = (short)((double)((Integer)result.getRight()).intValue() * (this.isCloud ? 3.0 : 1.5));
                if (this.smeltTime[slotSmelt] >= this.finishTime[slotSmelt] || !isItemSmeltable) {
                    ItemStack[] itemsOutput = new ItemStack[6];
                    System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                    byte outputSlot = this.getOutputSlot(itemsOutput, smeltStack, isItemSmeltable);
                    if (outputSlot > -1) {
                        ItemStack output = isItemSmeltable ? (ItemStack)result.getLeft() : smeltStack.func_77946_l().func_77979_a(1);
                        ItemStack stackInSlot = this.inventory.func_70301_a(11 + outputSlot);
                        if (isItemSmeltable) {
                            this.addExperience(((Float)result.getMiddle()).floatValue());
                        }
                        if (!stackInSlot.func_190926_b()) {
                            stackInSlot.func_190917_f(output.func_190916_E());
                        } else {
                            this.inventory.func_70299_a(11 + outputSlot, output);
                        }
                        this.inventory.func_70299_a(9 + slotSmelt, ItemStack.field_190927_a);
                        this.smeltTime[slotSmelt] = 0;
                        this.getNextSmeltItem(slotSmelt);
                        smeltStack = this.inventory.func_70301_a(9 + slotSmelt);
                        this.func_70296_d();
                    }
                }
            }
            if (!smeltStack.func_190926_b() || this.getNextSmeltItem(slotSmelt) || this.smeltTime[slotSmelt] <= 0) continue;
            this.smeltTime[slotSmelt] = 0;
        }
        boolean[] inUse = new boolean[2];
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            inUse[slotSmelt] = !this.inventory.func_70301_a(9 + slotSmelt).func_190926_b() && this.smeltTime[slotSmelt] < this.finishTime[slotSmelt];
        }
        if (!this.isCloud && this.burnTime < 1 && (inUse[0] || inUse[1])) {
            for (int slotFuel = 0; slotFuel < 3; slotFuel = (int)((byte)(slotFuel + 1))) {
                int value;
                ItemStack stackFuel = this.inventory.func_70301_a(slotFuel);
                if (stackFuel.func_190926_b() || (value = ForgeHooks.getBurnTime((ItemStack)stackFuel)) <= 0) continue;
                this.burnTime = this.burnValue = value;
                if (stackFuel.func_190916_E() > 1) {
                    stackFuel.func_190918_g(1);
                } else if (stackFuel.func_77973_b().hasContainerItem(stackFuel)) {
                    this.inventory.func_70299_a(slotFuel, stackFuel.func_77973_b().getContainerItem(stackFuel));
                } else {
                    this.inventory.func_70299_a(slotFuel, ItemStack.field_190927_a);
                }
                this.func_70296_d();
                break;
            }
        }
        if (this.isSmelting) {
            if (!inUse[0] && !inUse[1] || !this.isCloud && this.burnTime < 1) {
                this.isSmelting = false;
                Function.setBlock((IWorld)this.func_145831_w(), (BlockPos)this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)BlockFurnace.LIT, (Comparable)Boolean.valueOf(this.isSmelting))), (boolean)true);
            }
        } else if ((inUse[0] || inUse[1]) && (this.isCloud || !this.isCloud && this.burnTime > 0)) {
            this.isSmelting = true;
            Function.setBlock((IWorld)this.func_145831_w(), (BlockPos)this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)BlockFurnace.LIT, (Comparable)Boolean.valueOf(this.isSmelting))), (boolean)true);
        }
    }

    private boolean getNextSmeltItem(int slotSmelt) {
        for (int slotInput = 0; slotInput < 6; slotInput = (int)((byte)(slotInput + 1))) {
            ItemStack stackInput = this.inventory.func_70301_a(3 + slotInput);
            if (stackInput.func_190926_b()) continue;
            if (this.isSmeltable(stackInput)) {
                this.inventory.func_70299_a(9 + slotSmelt, stackInput.func_77979_a(1));
                if (stackInput.func_190926_b()) {
                    this.inventory.func_70299_a(3 + slotInput, ItemStack.field_190927_a);
                }
                this.smeltTime[slotSmelt] = 0;
                this.func_70296_d();
                return true;
            }
            boolean removed = false;
            int size = stackInput.func_190916_E();
            for (int count = 0; count < size; ++count) {
                ItemStack temp = stackInput.func_77946_l();
                temp.func_190920_e(1);
                ItemStack[] itemsOutput = new ItemStack[6];
                System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                byte outputSlot = this.getOutputSlot(itemsOutput, temp, false);
                if (outputSlot <= -1) continue;
                ItemStack stackInSlot = this.inventory.func_70301_a(11 + outputSlot);
                if (!stackInSlot.func_190926_b()) {
                    stackInSlot.func_190917_f(1);
                } else {
                    this.inventory.func_70299_a(11 + outputSlot, temp);
                }
                stackInput.func_190918_g(1);
                if (stackInput.func_190926_b()) {
                    this.inventory.func_70299_a(3 + slotInput, ItemStack.field_190927_a);
                }
                removed = true;
            }
            if (!removed) continue;
            this.func_70296_d();
        }
        return false;
    }

    public int getSmeltTime(int slot) {
        return slot < 2 ? this.smeltTime[slot] : 0;
    }

    public void setSmeltTime(int slot, int value) {
        if (slot > -1 && slot < 2) {
            this.smeltTime[slot] = value;
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnValue() {
        return this.burnValue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int item, int graphicWidth) {
        return this.smeltTime[item] == 0 ? 0 : this.smeltTime[item] * graphicWidth / this.finishTime[item];
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFuelProgressScaled(int graphicWidth) {
        return this.burnTime == 0 || this.burnValue == 0 ? 0 : MathHelper.func_76125_a((int)(this.burnTime * graphicWidth / this.burnValue), (int)1, (int)graphicWidth);
    }
}

