/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.BiomeHelper;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public class GenTrees
extends WorldGenerator {
    private static final Configuration.Menu_Generator.SubMenu_Trees config = Configuration.GENERATOR.TREES;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_APPLE_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_CHERRY_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_ORANGE_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_PEAR_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_PEACH_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_MANGO_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_LEMON_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_PLUM_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_BANANA_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_COCONUT_TREE;
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_MULBERRY_TREE;

    static void prep() {
        CONFIGURED_FEATURE_APPLE_TREE = ((Feature)WorldGenRegistry.FEATURE_APPLE_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Forest.get()).intValue(), (float)((Double)GenTrees.config.chance_Forest.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:forest_apple_tree"), CONFIGURED_FEATURE_APPLE_TREE);
        CONFIGURED_FEATURE_CHERRY_TREE = ((Feature)WorldGenRegistry.FEATURE_CHERRY_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Hills.get()).intValue(), (float)((Double)GenTrees.config.chance_Hills.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:hills_cherry_tree"), CONFIGURED_FEATURE_CHERRY_TREE);
        CONFIGURED_FEATURE_ORANGE_TREE = ((Feature)WorldGenRegistry.FEATURE_ORANGE_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Hills.get()).intValue(), (float)((Double)GenTrees.config.chance_Hills.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:hills_orange_tree"), CONFIGURED_FEATURE_ORANGE_TREE);
        CONFIGURED_FEATURE_PEAR_TREE = ((Feature)WorldGenRegistry.FEATURE_PEAR_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Forest.get()).intValue(), (float)((Double)GenTrees.config.chance_Forest.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:forest_pear_tree"), CONFIGURED_FEATURE_PEAR_TREE);
        CONFIGURED_FEATURE_PEACH_TREE = ((Feature)WorldGenRegistry.FEATURE_PEACH_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Mountain.get()).intValue(), (float)((Double)GenTrees.config.chance_Mountain.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:mountain_peach_tree"), CONFIGURED_FEATURE_PEACH_TREE);
        CONFIGURED_FEATURE_MANGO_TREE = ((Feature)WorldGenRegistry.FEATURE_MANGO_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Forest.get()).intValue(), (float)((Double)GenTrees.config.chance_Forest.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:forest_mango_tree"), CONFIGURED_FEATURE_MANGO_TREE);
        CONFIGURED_FEATURE_LEMON_TREE = ((Feature)WorldGenRegistry.FEATURE_LEMON_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Hills.get()).intValue(), (float)((Double)GenTrees.config.chance_Hills.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:hills_lemon_tree"), CONFIGURED_FEATURE_LEMON_TREE);
        CONFIGURED_FEATURE_PLUM_TREE = ((Feature)WorldGenRegistry.FEATURE_PLUM_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Hills.get()).intValue(), (float)((Double)GenTrees.config.chance_Hills.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:hills_plum_tree"), CONFIGURED_FEATURE_PLUM_TREE);
        CONFIGURED_FEATURE_BANANA_TREE = ((Feature)WorldGenRegistry.FEATURE_BANANA_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Jungle.get()).intValue(), (float)((Double)GenTrees.config.chance_Jungle.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:jungle_banana_tree"), CONFIGURED_FEATURE_BANANA_TREE);
        CONFIGURED_FEATURE_COCONUT_TREE = ((Feature)WorldGenRegistry.FEATURE_COCONUT_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Beach.get()).intValue(), (float)((Double)GenTrees.config.chance_Beach.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:beach_coconut_tree"), CONFIGURED_FEATURE_COCONUT_TREE);
        CONFIGURED_FEATURE_MULBERRY_TREE = ((Feature)WorldGenRegistry.FEATURE_MULBERRY_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(((Integer)GenTrees.config.attempts_Plains.get()).intValue(), (float)((Double)GenTrees.config.chance_Plains.get()).doubleValue(), 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:plains_mulberry_tree"), CONFIGURED_FEATURE_MULBERRY_TREE);
    }

    static void addTo(Biome biome) {
        if (!BiomeHelper.isCold(biome)) {
            Biome.Category category = biome.func_201856_r();
            if (((Boolean)GenTrees.config.generate_Banana.get()).booleanValue() && category == Biome.Category.JUNGLE) {
                GenTrees.addFeature(biome, CONFIGURED_FEATURE_BANANA_TREE);
            }
            if (!BiomeHelper.isHot(biome)) {
                boolean isHills = BiomeHelper.isHills(biome);
                if (((Boolean)GenTrees.config.generate_Apple.get()).booleanValue() && category == Biome.Category.FOREST) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_APPLE_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Cherry.get()).booleanValue() && isHills) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_CHERRY_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Orange.get()).booleanValue() && isHills) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_ORANGE_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Pear.get()).booleanValue() && category == Biome.Category.FOREST) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_PEAR_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Peach.get()).booleanValue() && (isHills || BiomeHelper.isMountain(biome))) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_PEACH_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Mango.get()).booleanValue() && category == Biome.Category.FOREST) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_MANGO_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Lemon.get()).booleanValue() && isHills) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_LEMON_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Plum.get()).booleanValue() && isHills) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_PLUM_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Coconut.get()).booleanValue() && category == Biome.Category.BEACH) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_COCONUT_TREE);
                }
                if (((Boolean)GenTrees.config.generate_Mulberry.get()).booleanValue() && category == Biome.Category.PLAINS) {
                    GenTrees.addFeature(biome, CONFIGURED_FEATURE_MULBERRY_TREE);
                }
            }
        }
    }
}

