/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;

public class WorldGenerator {
    private static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_CLOUDS;

    public static void load() {
        CONFIGURED_FEATURE_CLOUDS = ((Feature)WorldGenRegistry.FEATURE_CLOUDS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((Placement)WorldGenRegistry.PLACEMENT_SURFACE_WITH_CHANCE.get()).func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 1.0f, 0)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("terraqueous:clouds"), CONFIGURED_FEATURE_CLOUDS);
        GenDoodads.prep();
        GenFlowers.prep();
        GenPlants.prep();
        GenTrees.prep();
        Configuration.Menu_Generator config = Configuration.GENERATOR;
        WorldGenRegistries.field_243657_i.func_201756_e().forEach(biome -> {
            if (((Boolean)config.generateClouds.get()).booleanValue()) {
                WorldGenerator.addFeature(biome, CONFIGURED_FEATURE_CLOUDS);
            }
            if (((Boolean)config.generateDoodads.get()).booleanValue()) {
                GenDoodads.addTo(biome);
            }
            if (((Boolean)config.generateFlowers.get()).booleanValue()) {
                GenFlowers.addTo(biome);
            }
            if (((Boolean)config.generatePlants.get()).booleanValue()) {
                GenPlants.addTo(biome);
            }
            if (((Boolean)config.generateTrees.get()).booleanValue()) {
                GenTrees.addTo(biome);
            }
        });
    }

    public static boolean canGenerate(ISeedReader world, BlockPos pos, List<? extends String> blacklist) {
        return !WorldGenerator.isBlacklisted(world, blacklist) && pos.func_177956_o() >= 0 && pos.func_177956_o() <= WorldGenerator.getMaxWorldHeight(world);
    }

    public static int getMaxWorldHeight(ISeedReader world) {
        return world.func_230315_m_().func_241513_m_();
    }

    public static boolean isBlacklisted(ISeedReader world, List<? extends String> generatorList) {
        ResourceLocation registryName = WorldGenerator.getDimension((ISeedReader)world).field_242709_C;
        if (registryName != null) {
            String key = registryName.toString();
            for (String string : (List)Configuration.GENERATOR.DIM_BLACKLIST.global.get()) {
                if (!Pattern.compile(string).matcher(key).find()) continue;
                return true;
            }
            for (String string : generatorList) {
                if (!Pattern.compile(string).matcher(key).find()) continue;
                return true;
            }
        }
        return false;
    }

    public static DimensionType getDimension(ISeedReader world) {
        return world.func_230315_m_();
    }

    static void addFeature(Biome biome, ConfiguredFeature<?, ?> configuredFeature) {
        WorldGenerator.addFeature(biome, GenerationStage.Decoration.VEGETAL_DECORATION, configuredFeature);
    }

    public static void addFeature(Biome biome, GenerationStage.Decoration generationStep, ConfiguredFeature<?, ?> configuredFeature) {
        BiomeGenerationSettings settings = biome.func_242440_e();
        List features = settings.func_242498_c();
        if (features instanceof ImmutableList) {
            features = settings.field_242484_f = Lists.newArrayList((Iterable)features);
        }
        for (int index = features.size(); index <= generationStep.ordinal(); ++index) {
            features.add(Lists.newArrayList());
        }
        List suppliers = (List)features.get(generationStep.ordinal());
        if (suppliers instanceof ImmutableList) {
            suppliers = Lists.newArrayList((Iterable)suppliers);
            features.set(generationStep.ordinal(), suppliers);
        }
        suppliers.add(() -> configuredFeature);
    }
}

