/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public class FeatureClouds
extends Feature<NoFeatureConfig> {
    private static final Configuration.Menu_Generator.SubMenu_Clouds config = Configuration.GENERATOR.CLOUDS;
    private static final List<CloudEntry> CLOUD_ENTRIES = new ArrayList<CloudEntry>();
    private static final double[] DOUBLES = new double[3];

    public FeatureClouds() {
        super(NoFeatureConfig.field_236558_a_);
        if (CLOUD_ENTRIES.isEmpty()) {
            this.buildWeightedList();
        }
    }

    private void buildWeightedList() {
        CLOUD_ENTRIES.clear();
        FeatureClouds.DOUBLES[0] = (Double)FeatureClouds.config.chance_light.get();
        FeatureClouds.DOUBLES[1] = (Double)FeatureClouds.config.chance_dense.get();
        FeatureClouds.DOUBLES[2] = (Double)FeatureClouds.config.chance_storm.get();
        double skip = 0.0;
        if (((Boolean)FeatureClouds.config.generate_Light.get()).booleanValue()) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.LIGHT, DOUBLES[0]));
            skip += 1.0 - DOUBLES[0];
        }
        if (((Boolean)FeatureClouds.config.generate_Dense.get()).booleanValue()) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.DENSE, DOUBLES[1]));
            skip += 1.0 - DOUBLES[1];
        }
        if (((Boolean)FeatureClouds.config.generate_Storm.get()).booleanValue()) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.STORM, DOUBLES[2]));
            skip += 1.0 - DOUBLES[2];
        }
        if (skip > 0.0) {
            CLOUD_ENTRIES.add(new CloudEntry(null, skip));
        }
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig cfg) {
        CloudAPI.CloudType cloudType;
        if (CLOUD_ENTRIES.isEmpty() || !WorldGenerator.canGenerate(world, position, (List)Configuration.GENERATOR.DIM_BLACKLIST.clouds.get())) {
            return false;
        }
        if (DOUBLES[0] != (Double)FeatureClouds.config.chance_light.get() || DOUBLES[1] != (Double)FeatureClouds.config.chance_dense.get() || DOUBLES[2] != (Double)FeatureClouds.config.chance_storm.get()) {
            this.buildWeightedList();
        }
        if ((cloudType = ((CloudEntry)WeightedRandom.func_76271_a((Random)random, FeatureClouds.CLOUD_ENTRIES)).cloudType) == null) {
            return false;
        }
        Block block = null;
        int numberOfBlocks = 0;
        switch (cloudType) {
            case LIGHT: {
                block = Values.blockClouds.get((Object)CloudAPI.CloudType.LIGHT);
                numberOfBlocks = this.getCount(random, (Integer)FeatureClouds.config.minSize_Light.get(), (Integer)FeatureClouds.config.maxSize_Light.get());
                break;
            }
            case DENSE: {
                block = Values.blockClouds.get((Object)CloudAPI.CloudType.DENSE);
                numberOfBlocks = this.getCount(random, (Integer)FeatureClouds.config.minSize_Dense.get(), (Integer)FeatureClouds.config.maxSize_Dense.get());
                break;
            }
            case STORM: {
                block = Values.blockClouds.get((Object)CloudAPI.CloudType.STORM);
                numberOfBlocks = this.getCount(random, (Integer)FeatureClouds.config.minSize_Storm.get(), (Integer)FeatureClouds.config.maxSize_Storm.get());
            }
        }
        if (numberOfBlocks > 0 && block instanceof BlockClouds) {
            int randPosX = position.func_177958_n() + 4 + random.nextInt(5);
            int randPosY = (Integer)FeatureClouds.config.height_Override.get() > 0 ? (Integer)FeatureClouds.config.height_Override.get() : (int)((float)world.func_217301_I() * 0.75f) - 6 + random.nextInt(7);
            int randPosZ = position.func_177952_p() + 4 + random.nextInt(5);
            this.generateCloud(random, (BlockState)block.func_176223_P().func_206870_a((Property)CloudAPI.KICKABLE, (Comparable)Boolean.valueOf(true)), numberOfBlocks, (IWorld)world, randPosX, randPosY, randPosZ);
            return true;
        }
        return false;
    }

    private int getCount(Random random, int min, int max) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return min + random.nextInt(1 + max - min);
    }

    private void generateCloud(Random random, BlockState state, int numberOfBlocks, IWorld world, int x, int y, int z) {
        float pi = (float)Math.PI + (float)(random.nextInt(3) - 1);
        float ranPi = random.nextFloat() * pi;
        double sX1 = (float)(x + 8) + MathHelper.func_76126_a((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sX2 = (float)(x + 8) - MathHelper.func_76126_a((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sZ1 = (float)(z + 8) + MathHelper.func_76134_b((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sZ2 = (float)(z + 8) - MathHelper.func_76134_b((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sY1 = y + random.nextInt(3) - 2;
        double sY2 = y + random.nextInt(3) - 2;
        for (int placeBlock = 0; placeBlock <= numberOfBlocks; ++placeBlock) {
            double d6 = sX1 + (sX2 - sX1) * (double)placeBlock / (double)numberOfBlocks;
            double d7 = sY1 + (sY2 - sY1) * (double)placeBlock / (double)numberOfBlocks;
            double d8 = sZ1 + (sZ2 - sZ1) * (double)placeBlock / (double)numberOfBlocks;
            double d9 = random.nextDouble() * (double)numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)placeBlock * pi / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)placeBlock * pi / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int minX = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int minY = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int minZ = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int maxX = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int maxY = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int maxZ = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int posX = minX; posX <= maxX; ++posX) {
                double d12 = ((double)posX + 0.5 - d6) / (d10 / 2.0);
                if (d12 * d12 >= 1.0) continue;
                for (int posY = minY; posY <= maxY; ++posY) {
                    double d13 = ((double)posY + 0.5 - d7) / (d11 / 2.0);
                    if (d12 * d12 + d13 * d13 >= 1.0) continue;
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        double d14 = ((double)posZ + 0.5 - d8) / (d10 / 2.0);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        if (d12 * d12 + d13 * d13 + d14 * d14 >= 1.0 || !world.func_175623_d(pos) || Math.abs(posX - x) + Math.abs(posY - y) + Math.abs(posZ - z) >= 16 + random.nextInt(9)) continue;
                        this.func_230367_a_((IWorldWriter)world, pos, state);
                    }
                }
            }
        }
    }

    public static class CloudEntry
    extends WeightedRandom.Item {
        public final CloudAPI.CloudType cloudType;

        public CloudEntry(CloudAPI.CloudType cloudType, double weight) {
            super((int)(weight * 1000.0));
            this.cloudType = cloudType;
        }
    }
}

