/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniCoconutTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class FeatureCoconutTree
extends FeatureTreeBase {
    private static final byte[] mapFoliage = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 1, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 5, 5, 5, 1, 5, 5, 5, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5, 0, 0, 5, 5, 5, 5, 0, 0, 0, 0, 5, 4, 5, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public FeatureCoconutTree() {
        this(false);
    }

    public FeatureCoconutTree(boolean doBlockNotifyOnPlace) {
        super(doBlockNotifyOnPlace, PlantAPI.TreeType.COCONUT);
        this.MINI_TREE = new FeatureMiniCoconutTree(doBlockNotifyOnPlace);
    }

    @Override
    protected void setup(PlantAPI.TreeType tree) {
        this.LOG = Values.blockLogs.get((Object)tree).func_176223_P();
        this.WOOD = Values.blockWoods.get((Object)tree).func_176223_P();
        this.LEAVES = Values.blockLeaves.get((Object)tree).func_176223_P();
    }

    @Override
    protected int getTreeWidth() {
        return 7;
    }

    @Override
    protected int getFoliageHeight() {
        return 4;
    }

    @Override
    protected int getTrunkHeight(Random random) {
        return 0;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapFoliage[index];
    }

    @Override
    protected BlockState getBlockState(int mapValue, Random random) {
        switch (mapValue) {
            case 1: {
                return this.LOG;
            }
            case 4: {
                return this.WOOD;
            }
            case 5: {
                return this.LEAVES;
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected boolean placeTree(Set<BlockPos> changedBlocks, ISeedReader world, Random random, BlockPos position, MutableBoundingBox boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int sY2;
        int segment;
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
        int treeWidth = this.getTreeWidth();
        int foliageHeight = this.getFoliageHeight();
        int[] trunkSegment = new int[]{random.nextInt(3) + 3, random.nextInt(3) + 2, random.nextInt(2) + 1, random.nextInt(2) + 1};
        int trunkHeight = trunkSegment[0] + trunkSegment[1] + trunkSegment[2] + trunkSegment[3] + 3;
        if (position.func_177956_o() < 1 || position.func_177956_o() + 1 + trunkHeight + foliageHeight > WorldGenerator.getMaxWorldHeight(world)) {
            return false;
        }
        if (!FeatureCoconutTree.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b(), this.getSapling())) {
            return false;
        }
        BlockPos foliagePos = position.func_177967_a(direction, 3);
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        mPos.func_189533_g((Vector3i)position);
        int chY = position.func_177956_o();
        for (segment = 0; segment < 4; segment = (int)((byte)(segment + 1))) {
            for (sY2 = 0; sY2 < trunkSegment[segment]; sY2 = (int)((byte)(sY2 + 1))) {
                mPos.func_185336_p(chY);
                if (!FeatureCoconutTree.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                    return false;
                }
                ++chY;
            }
            if (segment >= 3) continue;
            mPos.func_185336_p(chY);
            if (!FeatureCoconutTree.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                return false;
            }
            mPos.func_189536_c(direction);
            if (!FeatureCoconutTree.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                return false;
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = foliagePos.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = foliagePos.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    if (this.getMapValue(index) > 0) {
                        mPos.func_181079_c(chX, chY, chZ);
                        if (!FeatureCoconutTree.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        mPos.func_189533_g((Vector3i)position);
        chY = position.func_177956_o();
        for (segment = 0; segment < 4; segment = (int)((byte)(segment + 1))) {
            for (sY2 = 0; sY2 < trunkSegment[segment]; sY2 = (int)((byte)(sY2 + 1))) {
                mPos.func_185336_p(chY);
                if (FeatureCoconutTree.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                    this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(1, random), boundingBox);
                }
                ++chY;
            }
            if (segment >= 3) continue;
            mPos.func_185336_p(chY);
            if (FeatureCoconutTree.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(4, random), boundingBox);
            }
            mPos.func_189536_c(direction);
            if (FeatureCoconutTree.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(4, random), boundingBox);
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = foliagePos.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = foliagePos.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.func_181079_c(chX, chY, chZ);
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureCoconutTree.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                        this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        return true;
    }
}

