/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBanana;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniTreeBase;

public class FeatureMiniBananaTree
extends FeatureMiniTreeBase {
    private int flowerChance = 20;
    private static final byte[] mapMiniTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 5, 0, 0, 9, 5, 1, 5, 9, 0, 0, 5, 0, 0, 0, 0, 9, 0, 0, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0, 5, 5, 4, 5, 5, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public FeatureMiniBananaTree(boolean doBlockNotifyOnPlace) {
        super(doBlockNotifyOnPlace, PlantAPI.TreeType.BANANA);
    }

    @Override
    protected int getTreeWidth() {
        return 5;
    }

    @Override
    protected int getTreeHeight() {
        return 5;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapMiniTree[index];
    }

    @Override
    protected void postPlacement(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos position, MutableBoundingBox boundingBox, int yOffset) {
        super.postPlacement(changedBlocks, world, random, position, boundingBox, yOffset);
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        int treeWidth = this.getTreeWidth();
        int treeHeight = this.getTreeHeight();
        int chY = position.func_177956_o() + yOffset;
        for (int sY = 0; sY < treeHeight; sY = (int)((byte)(sY + 1))) {
            int chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (int sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                int chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (int sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.func_181079_c(chX, chY, chZ);
                    int index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue == 9 && FeatureMiniBananaTree.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                        if (random.nextInt(100) < this.flowerChance) {
                            this.flowerChance = 0;
                            this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, BlockLeavesBanana.getFlowerVariant(this.LEAVES), boundingBox);
                        }
                        this.flowerChance += 15;
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
    }
}

