/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockCactus;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public class FeaturePricklyPearPlant
extends Feature<NoFeatureConfig> {
    public FeaturePricklyPearPlant() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        if (!WorldGenerator.canGenerate(world, position, (List)Configuration.GENERATOR.DIM_BLACKLIST.plants.get())) {
            return false;
        }
        BlockCactus cactus = (BlockCactus)Values.blockPlants.get((Object)PlantAPI.PlantType.CACTUS);
        if (!FeaturePricklyPearPlant.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b(), cactus)) {
            return false;
        }
        if (random.nextBoolean()) {
            this.func_230367_a_((IWorldWriter)world, position, (BlockState)cactus.func_176223_P().func_206870_a(BlockCactus.VARIANT, (Comparable)((Object)BlockCactus.EnumType.SMALL)));
        } else if (random.nextBoolean()) {
            this.func_230367_a_((IWorldWriter)world, position, (BlockState)cactus.func_176223_P().func_206870_a(BlockCactus.VARIANT, (Comparable)((Object)BlockCactus.EnumType.LARGE)));
        } else {
            this.func_230367_a_((IWorldWriter)world, position, (BlockState)cactus.func_176223_P().func_206870_a(BlockCactus.VARIANT, (Comparable)((Object)BlockCactus.EnumType.FRUIT)));
        }
        return false;
    }

    protected static boolean isSoil(IWorldGenerationBaseReader world, BlockPos pos, IPlantable plantable) {
        if (!(world instanceof IBlockReader) || plantable == null) {
            return world.func_217375_a(pos, state -> Tags.Blocks.SAND.func_230235_a_((Object)state.func_177230_c()));
        }
        return world.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)world, pos, Direction.UP, plantable));
    }
}

