/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeaves;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.AbstractTreeFeature;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniTreeBase;

public abstract class FeatureTreeBase
extends AbstractTreeFeature<NoFeatureConfig> {
    protected FeatureMiniTreeBase MINI_TREE;
    protected BlockState LOG;
    protected BlockState LOG_X;
    protected BlockState LOG_Z;
    protected BlockState WOOD;
    protected BlockState LEAVES;
    protected BlockState LEAVES_FLOWER;
    protected BlockState LEAVES_FRUIT;
    protected boolean rotateMap = false;
    private static final byte[] mapMiniTree = new byte[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 6, 6, 6, 4, 6, 6, 6, 6, 0, 6, 0, 6, 5, 6, 0, 6, 0};

    public FeatureTreeBase(boolean doBlockNotifyOnPlace, PlantAPI.TreeType tree) {
        super(NoFeatureConfig.field_236558_a_, doBlockNotifyOnPlace);
        this.setSapling((IPlantable)Values.blockSaplings.get((Object)tree));
        this.setup(tree);
    }

    protected void setup(PlantAPI.TreeType tree) {
        this.LOG = Values.blockLogs.get((Object)tree).func_176223_P();
        this.LOG_X = (BlockState)this.LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
        this.LOG_Z = (BlockState)this.LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
        this.WOOD = Values.blockWoods.get((Object)tree).func_176223_P();
        this.LEAVES = Values.blockLeaves.get((Object)tree).func_176223_P();
        this.LEAVES_FLOWER = BlockLeaves.getAltVariant(this.LEAVES, false);
        this.LEAVES_FRUIT = BlockLeaves.getAltVariant(this.LEAVES, true);
    }

    protected abstract int getTreeWidth();

    protected abstract int getFoliageHeight();

    protected abstract int getTrunkHeight(Random var1);

    protected abstract byte getMapValue(int var1);

    protected BlockState getBlockState(int mapValue, Random random) {
        switch (mapValue) {
            case 1: {
                return this.LOG;
            }
            case 2: {
                return this.rotateMap ? this.LOG_Z : this.LOG_X;
            }
            case 3: {
                return this.rotateMap ? this.LOG_X : this.LOG_Z;
            }
            case 4: {
                return this.WOOD;
            }
            case 6: {
                if (random.nextInt(15) == 0) {
                    return this.LEAVES_FLOWER;
                }
                if (random.nextInt(15) == 0) {
                    return this.LEAVES_FRUIT;
                }
            }
            case 5: {
                return this.LEAVES;
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected final boolean place(Set<BlockPos> changedBlocks, ISeedReader world, Random random, BlockPos position, MutableBoundingBox boundingBox) {
        if (!world.func_217375_a(position, state -> state.func_177230_c() instanceof SaplingBlock) && WorldGenerator.isBlacklisted(world, (List)Configuration.GENERATOR.DIM_BLACKLIST.trees.get())) {
            return false;
        }
        return this.placeTree(changedBlocks, world, random, position, boundingBox) || this.MINI_TREE != null && this.MINI_TREE.placeTree(changedBlocks, world, random, position, boundingBox);
    }

    protected boolean placeTree(Set<BlockPos> changedBlocks, ISeedReader world, Random random, BlockPos position, MutableBoundingBox boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int treeWidth = this.getTreeWidth();
        int foliageHeight = this.getFoliageHeight();
        int trunkHeight = this.getTrunkHeight(random);
        if (position.func_177956_o() < 1 || position.func_177956_o() + 1 + trunkHeight + foliageHeight > WorldGenerator.getMaxWorldHeight(world)) {
            return false;
        }
        if (!FeatureTreeBase.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b(), this.sapling)) {
            return false;
        }
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        mPos.func_189533_g((Vector3i)position);
        int chY = position.func_177956_o();
        for (sY = 0; sY < trunkHeight; sY = (int)((byte)(sY + 1))) {
            mPos.func_185336_p(chY);
            if (!FeatureTreeBase.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                return false;
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = this.getIndex(sX, sY, sZ, treeWidth);
                    if (this.getMapValue(index) > 0) {
                        mPos.func_181079_c(chX, chY, chZ);
                        if (!FeatureTreeBase.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        mPos.func_189533_g((Vector3i)position);
        chY = position.func_177956_o();
        for (sY = 0; sY < trunkHeight; sY = (int)((byte)(sY + 1))) {
            mPos.func_185336_p(chY);
            if (FeatureTreeBase.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(1, random), boundingBox);
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.func_181079_c(chX, chY, chZ);
                    index = this.getIndex(sX, sY, sZ, treeWidth);
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureTreeBase.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                        this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        this.postPlacement(changedBlocks, (IWorldGenerationReader)world, random, position, boundingBox, trunkHeight);
        return true;
    }

    private int getIndex(int sX, int sY, int sZ, int treeWidth) {
        if (this.rotateMap) {
            return sY * treeWidth * treeWidth + sZ + sX * treeWidth;
        }
        return sY * treeWidth * treeWidth + sX + sZ * treeWidth;
    }

    protected void setState(Set<BlockPos> changedBlocks, IWorldWriter world, BlockPos pos, BlockState state, MutableBoundingBox boundingBox) {
        if (state != null && !state.func_196958_f()) {
            this.setLogState(changedBlocks, world, pos, state, boundingBox);
        }
    }

    protected void postPlacement(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos position, MutableBoundingBox boundingBox, int yOffset) {
    }
}

