/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.curios;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.terraqueous.common.item.ItemBurniumBelt;
import shetiphian.terraqueous.common.item.ItemToonTrotters;
import shetiphian.terraqueous.common.item.ItemWaterPearl;
import shetiphian.terraqueous.common.misc.EventHandler;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketEquipmentChange;
import shetiphian.terraqueous.modintegration.curios.Curios_Base;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class Curios_Active
extends Curios_Base {
    public static void init() {
        if (CurioChangeEvent.class != null && ICurio.class != null) {
            MinecraftForge.EVENT_BUS.register((Object)new Curios_Active());
            Curios_Base.INSTANCE = new Curios_Active();
        }
    }

    @SubscribeEvent
    public void curioChangeEvent(CurioChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        String key = String.format("Curio[%d]{%s}", event.getSlotIndex(), event.getIdentifier());
        if (entity instanceof PlayerEntity) {
            if (entity instanceof ServerPlayerEntity && entity.field_70170_p != null) {
                NetworkHandler.sendToPlayer(new PacketEquipmentChange(key, event.getFrom(), event.getTo()), (ServerPlayerEntity)entity);
            }
        } else {
            EventHandler.processLivingEquipmentChangeEvent(entity, key, event.getFrom(), event.getTo());
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, String id) {
        if (capability == CuriosCapability.ITEM) {
            switch (id) {
                case "burnium_belt": {
                    return LazyOptional.of(() -> BurniumBelt.INSTANCE).cast();
                }
                case "toon_trotters": {
                    return LazyOptional.of(() -> ToonTrotters.INSTANCE).cast();
                }
                case "water_pearl": {
                    return LazyOptional.of(() -> WaterPearl.INSTANCE).cast();
                }
            }
        }
        return LazyOptional.empty();
    }

    private static class WaterPearl
    implements ICurio {
        private static final WaterPearl INSTANCE = new WaterPearl();

        private WaterPearl() {
        }

        public void curioTick(String identifier, int index, LivingEntity livingEntity) {
            ItemWaterPearl.resetAir((Entity)livingEntity);
        }
    }

    private static class ToonTrotters
    implements ICurio {
        private static final ToonTrotters INSTANCE = new ToonTrotters();

        private ToonTrotters() {
        }

        public void curioTick(String identifier, int index, LivingEntity livingEntity) {
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getStacksHandler(identifier).ifPresent(stacks -> {
                ItemStack stack = stacks.getStacks().getStackInSlot(index);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemToonTrotters) {
                    ItemToonTrotters.checkFall(stack, (Entity)livingEntity);
                }
            }));
        }
    }

    private static class BurniumBelt
    implements ICurio {
        private static final BurniumBelt INSTANCE = new BurniumBelt();

        private BurniumBelt() {
        }

        public void curioTick(String identifier, int index, LivingEntity livingEntity) {
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getStacksHandler(identifier).ifPresent(stacks -> {
                ItemStack stack = stacks.getStacks().getStackInSlot(index);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBurniumBelt) {
                    ItemBurniumBelt.adjustHeat(stack, livingEntity);
                }
            }));
        }
    }
}

