/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.modintegration.jei.EnderTableRecipeWrapper;

public class EnderTableRecipeCategory
implements IRecipeCategory<EnderTableRecipeWrapper> {
    public static final ResourceLocation ENDERTABLE = new ResourceLocation("terraqueous:endertable");
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public EnderTableRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("terraqueous", "textures/item/ender_book.png");
        this.background = guiHelper.createDrawable(Textures.ENDERTABLE.get(), 140, 0, 116, 34);
        this.icon = guiHelper.drawableBuilder(location, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.localizedName = Localization.get((String)"block.terraqueous.ender_table");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ENDERTABLE;
    }

    public Class<? extends EnderTableRecipeWrapper> getRecipeClass() {
        return EnderTableRecipeWrapper.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(EnderTableRecipeWrapper wrapper, IIngredients ingredients) {
        wrapper.getIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout layout, EnderTableRecipeWrapper wrapper, IIngredients ingredients) {
        IGuiIngredientGroup guiIngredientGroup = layout.getIngredientsGroup(VanillaTypes.ITEM);
        guiIngredientGroup.init(0, false, 94, 8);
        guiIngredientGroup.init(1, true, 0, 4);
        guiIngredientGroup.init(2, true, 18, 4);
        this.craftingGridHelper.setInputs(guiIngredientGroup, ingredients.getInputs(VanillaTypes.ITEM));
        IGuiItemStackGroup guiItemStackGroup = layout.getItemStacks();
        guiItemStackGroup.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(EnderTableRecipeWrapper wrapper, MatrixStack matrixStack, double mouseX, double mouseY) {
        wrapper.drawInfo(matrixStack, Minecraft.func_71410_x(), mouseX, mouseY);
    }

    public List<ITextComponent> getTooltipStrings(EnderTableRecipeWrapper wrapper, double mouseX, double mouseY) {
        return wrapper.getTooltipStrings(mouseX, mouseY);
    }
}

