/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.inventory.ContainerCloudFurnace;
import shetiphian.terraqueous.common.inventory.ContainerCloudWorkbench;
import shetiphian.terraqueous.common.inventory.ContainerCraftFurnace;
import shetiphian.terraqueous.common.inventory.ContainerEnderTable;
import shetiphian.terraqueous.common.item.ItemBlockDryingHay;
import shetiphian.terraqueous.modintegration.jei.CraftBenchTransferHandler;
import shetiphian.terraqueous.modintegration.jei.EnderTableHandlers;
import shetiphian.terraqueous.modintegration.jei.EnderTableRecipeCategory;

@JeiPlugin
public class TerraqueousPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("terraqueous:jei-plugin");
    private static boolean isRegistered_TransferHandlers = false;
    private static boolean isRegistered_Recipes = false;
    private static boolean isRegistered_Categories = false;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        if (isRegistered_TransferHandlers) {
            return;
        }
        isRegistered_TransferHandlers = true;
        registry.addRecipeTransferHandler((IRecipeTransferHandler)new CraftBenchTransferHandler(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipeTransferHandler(ContainerCloudFurnace.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 2, 36);
        registry.addRecipeTransferHandler(ContainerCloudWorkbench.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerCraftFurnace.class, VanillaRecipeCategoryUid.FURNACE, 3, 6, 11, 42);
        registry.addRecipeTransferHandler(ContainerCraftFurnace.class, VanillaRecipeCategoryUid.FUEL, 0, 3, 11, 42);
        registry.addRecipeTransferHandler(ContainerEnderTable.class, EnderTableRecipeCategory.ENDERTABLE, 0, 2, 2, 36);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (isRegistered_Recipes) {
            return;
        }
        isRegistered_Recipes = true;
        registry.addRecipes(EnderTableHandlers.buildRecipeList(), EnderTableRecipeCategory.ENDERTABLE);
        ArrayList<String> prep = new ArrayList<String>();
        prep.add(Localization.get((String)"info.terraqueous.drying.finished.txt"));
        prep.add("");
        Localization.multiLine((String)"info.terraqueous.drying.source.msg", prep);
        String[] info = prep.toArray(new String[0]);
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)Values.blockHayPile), VanillaTypes.ITEM, info);
        info[0] = Localization.get((String)"info.terraqueous.drying.create.txt") + " " + Localization.get((String)"block.terraqueous.loose_hay");
        for (int progress = 9; progress < 10; ++progress) {
            registry.addIngredientInfo((Object)ItemBlockDryingHay.create(new ItemStack((IItemProvider)Values.blockDryingHay), progress), VanillaTypes.ITEM, info);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (isRegistered_Categories) {
            return;
        }
        isRegistered_Categories = true;
        registry.addRecipeCategories(new IRecipeCategory[]{new EnderTableRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

