/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.mfr;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockCactus;
import shetiphian.terraqueous.common.block.BlockFlowers;
import shetiphian.terraqueous.common.block.BlockLeaves;
import shetiphian.terraqueous.common.block.BlockLeavesBanana;
import shetiphian.terraqueous.common.block.BlockPineapple;
import shetiphian.terraqueous.common.block.BlockVine;

public class Recollectable {
    @SubscribeEvent
    public void register(RegistryEvent.Register<PlantRecollectable> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new Flowers("terraqueous:flowers"));
        registry.register((IForgeRegistryEntry)new Plants("terraqueous:fruit_plants"));
        registry.register((IForgeRegistryEntry)new Trees("terraqueous:fruit_trees"));
    }

    public static class Trees
    extends CommonRecollectable {
        Trees(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, BlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockLeaves && state.func_177229_b(BlockLeaves.VARIANT) == BlockLeaves.EnumType.FRUIT) {
                return true;
            }
            return block instanceof BlockLeavesBanana && state.func_177229_b(BlockLeavesBanana.VARIANT) == BlockLeavesBanana.EnumType.FRUIT;
        }

        @Override
        protected void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, BlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockLeaves) {
                PlantAPI.TreeType type = ((BlockLeaves)block).getTreeType();
                if (Values.itemTreeFruit.containsKey((Object)type)) {
                    drops.add((Object)new ItemStack((IItemProvider)Values.itemTreeFruit.get((Object)type)));
                }
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(BlockLeaves.VARIANT, (Comparable)((Object)BlockLeaves.EnumType.NORMAL))), (boolean)true);
            }
            if (block instanceof BlockLeavesBanana) {
                if (Values.itemTreeFruit.containsKey((Object)PlantAPI.TreeType.BANANA)) {
                    drops.add((Object)new ItemStack((IItemProvider)Values.itemTreeFruit.get((Object)PlantAPI.TreeType.BANANA), world.field_73012_v.nextInt(4) + 2));
                }
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(BlockLeavesBanana.VARIANT, (Comparable)((Object)BlockLeavesBanana.EnumType.STALK_BARE))), (boolean)true);
            }
        }

        @Override
        public void getNames(List<String> names) {
            names.add(Localization.get((String)"block.terraqueous.apple_leaves"));
            names.add(Localization.get((String)"block.terraqueous.cherry_leaves"));
            names.add(Localization.get((String)"block.terraqueous.orange_leaves"));
            names.add(Localization.get((String)"block.terraqueous.pear_leaves"));
            names.add(Localization.get((String)"block.terraqueous.peach_leaves"));
            names.add(Localization.get((String)"block.terraqueous.mango_leaves"));
            names.add(Localization.get((String)"block.terraqueous.lemon_leaves"));
            names.add(Localization.get((String)"block.terraqueous.plum_leaves"));
            names.add(Localization.get((String)"block.terraqueous.banana_stalk"));
            names.add(Localization.get((String)"block.terraqueous.mulberry_leaves"));
        }
    }

    public static class Plants
    extends CommonRecollectable {
        Plants(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, BlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockPineapple && state.func_177229_b(BlockPineapple.VARIANT) == BlockPineapple.EnumType.FRUIT) {
                return true;
            }
            if (block instanceof BlockCactus && state.func_177229_b(BlockCactus.VARIANT) == BlockCactus.EnumType.FRUIT) {
                return true;
            }
            return block instanceof BlockVine && (Boolean)state.func_177229_b((Property)BlockVine.HAS_FRUIT) != false;
        }

        @Override
        public void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, BlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockPineapple) {
                if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.PINEAPPLE)) {
                    drops.add((Object)new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.PINEAPPLE)));
                }
                world.func_217377_a(pos, false);
                return;
            }
            if (block instanceof BlockCactus) {
                if (Values.itemPlantFruit.containsKey((Object)PlantAPI.PlantType.CACTUS)) {
                    drops.add((Object)new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)PlantAPI.PlantType.CACTUS), world.field_73012_v.nextInt(2) + 1));
                }
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(BlockCactus.VARIANT, (Comparable)((Object)BlockCactus.EnumType.LARGE))), (boolean)true);
                return;
            }
            if (block instanceof BlockVine) {
                PlantAPI.PlantType type = ((BlockVine)block).getPlantType();
                if (Values.itemPlantFruit.containsKey((Object)type)) {
                    drops.add((Object)new ItemStack((IItemProvider)Values.itemPlantFruit.get((Object)type)));
                }
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)BlockVine.HAS_FRUIT, (Comparable)Boolean.valueOf(false))), (boolean)true);
            }
        }

        @Override
        public void getNames(List<String> names) {
            names.add(Localization.get((String)"block.terraqueous.pineapple"));
            names.add(Localization.get((String)"block.terraqueous.cactus"));
            names.add(Localization.get((String)"block.terraqueous.grapevine"));
            names.add(Localization.get((String)"block.terraqueous.lifevine"));
            names.add(Localization.get((String)"block.terraqueous.deathvine"));
        }
    }

    public static class Flowers
    extends CommonRecollectable {
        Flowers(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, BlockState state) {
            return state.func_177230_c() instanceof BlockFlowers && (Integer)state.func_177229_b((Property)BlockFlowers.SIZE) == BlockFlowers.maxSize();
        }

        @Override
        public void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, BlockState state) {
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)BlockFlowers.SIZE, (Comparable)Integer.valueOf(0))), (boolean)true);
            drops.add((Object)new ItemStack((IItemProvider)state.func_177230_c(), world.field_73012_v.nextInt(2) + 1));
        }

        @Override
        public void getNames(List<String> names) {
            for (Block flower : Values.blockFlowers) {
                names.add(Localization.get((String)flower.func_149739_a()));
            }
        }
    }

    private static abstract class CommonRecollectable
    extends PlantRecollectable {
        CommonRecollectable(String name) {
            super(name);
        }

        public final List<ItemStack> doHarvestOperation(World world, BlockPos pos, BlockState state) {
            NonNullList drops = NonNullList.func_191196_a();
            this.doHarvestOperation((NonNullList<ItemStack>)drops, world, pos, state);
            return drops;
        }

        protected abstract void doHarvestOperation(NonNullList<ItemStack> var1, World var2, BlockPos var3, BlockState var4);

        public final boolean shouldCheckNextPlant(World world, BlockPos pos, BlockState state) {
            return true;
        }

        public final List<String> getRecollectablesNames() {
            ArrayList<String> names = new ArrayList<String>();
            this.getNames(names);
            return names;
        }

        protected abstract void getNames(List<String> var1);

        public final PlantRecollectable.Type getRecollectableType() {
            return PlantRecollectable.Type.PLANT;
        }
    }
}

