/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.power;

import java.util.concurrent.atomic.AtomicBoolean;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;

public class Joules {
    public static void init() {
        if ((Double)Configuration.STORMFORGE.powerMultiplierJ.get() > 0.0 && IStrictEnergyHandler.class != null) {
            StormForgeRegistry.register(new RechargeHandler());
        }
    }

    public static class RechargeHandler
    implements IStormForgeRechargeHandler {
        @Override
        public boolean handleStack(ItemStack stack) {
            return !stack.func_190926_b() && stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY, null).isPresent();
        }

        @Override
        public boolean charge(ItemStack stack, double amount, boolean outright) {
            if (this.handleStack(stack)) {
                LazyOptional storage = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY, null);
                AtomicBoolean charge = new AtomicBoolean(true);
                storage.ifPresent(handler -> {
                    FloatingLong pre = handler.getEnergy(0);
                    handler.setEnergy(0, outright ? FloatingLong.MAX_VALUE : FloatingLong.create((double)amount));
                    charge.set(!pre.equals(handler.getEnergy(0)));
                });
                return charge.get();
            }
            return false;
        }

        @Override
        public boolean isFull(ItemStack stack) {
            if (this.handleStack(stack)) {
                LazyOptional storage = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY, null);
                AtomicBoolean isFull = new AtomicBoolean(true);
                storage.ifPresent(handler -> isFull.set(handler.getEnergy(0).compareTo(handler.getMaxEnergy(0)) >= 0));
                return isFull.get();
            }
            return true;
        }

        @Override
        public double multiplier() {
            return (Double)Configuration.STORMFORGE.powerMultiplierJ.get();
        }
    }
}

