/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Items;

import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.TAMod;
import com.elseytd.theaurorian.Util.GenerationHelper;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_DarkstoneDungeon;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_MoonTemple;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_Runestone_Tower;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TAItem_Special_Locator
extends Item {
    public static final String ITEMNAME = "locator";

    public TAItem_Special_Locator() {
        this.func_77637_a(TAMod.CREATIVE_TAB);
        this.setRegistryName(ITEMNAME);
        this.func_77625_d(1);
        this.func_77656_e(30);
        this.func_77655_b("theaurorian.locator");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            switch (this.getSelectedDungeon(itemstack)) {
                case "Moontemple": {
                    this.setSelectedDungeon(itemstack, "Runestone");
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"string.theaurorian.item.locator1", (Object[])new Object[0])), true);
                    break;
                }
                default: {
                    this.setSelectedDungeon(itemstack, "Darkstone");
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"string.theaurorian.item.locator3", (Object[])new Object[0])), true);
                    break;
                }
                case "Darkstone": {
                    this.setSelectedDungeon(itemstack, "Moontemple");
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"string.theaurorian.item.locator2", (Object[])new Object[0])), true);
                    break;
                }
            }
        } else {
            ChunkPos dungeon;
            switch (this.getSelectedDungeon(itemstack)) {
                case "Moontemple": {
                    dungeon = GenerationHelper.getNearestStructure(new TAWorldGenerator_MoonTemple(), playerIn, TAConfig.Config_DungeonDensity * 4);
                    break;
                }
                default: {
                    dungeon = GenerationHelper.getNearestStructure(new TAWorldGenerator_Runestone_Tower(), playerIn, TAConfig.Config_DungeonDensity * 2);
                    break;
                }
                case "Darkstone": {
                    dungeon = GenerationHelper.getNearestStructure(new TAWorldGenerator_DarkstoneDungeon(), playerIn, TAConfig.Config_DungeonDensity * 6);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_193781_bp, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (dungeon != null) {
                if (worldIn.field_72995_K) {
                    double lookx = 0.25 + (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(playerIn.field_70759_as))) * MathHelper.func_76134_b((float)((float)Math.toRadians(playerIn.field_70125_A))));
                    double looky = 0.25 + (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(playerIn.field_70125_A))));
                    double lookz = 0.25 + (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(playerIn.field_70759_as))) * MathHelper.func_76134_b((float)((float)Math.toRadians(playerIn.field_70125_A))));
                    double y = playerIn.field_70163_u + 1.0 + Item.field_77697_d.nextDouble() * 6.0 / 16.0;
                    double speed = 0.01;
                    double targetx = playerIn.field_70165_t - (double)(dungeon.field_77276_a * 16);
                    double targetz = playerIn.field_70161_v - (double)(dungeon.field_77275_b * 16);
                    double originx = playerIn.field_70165_t;
                    double originz = playerIn.field_70161_v;
                    double partx = targetx * -speed;
                    double partz = targetz * -speed;
                    if (partx < -0.5) {
                        partx = -0.5;
                    }
                    if (partx > 0.5) {
                        partx = 0.5;
                    }
                    if (partz < -0.5) {
                        partz = -0.5;
                    }
                    if (partz > 0.5) {
                        partz = 0.5;
                    }
                    double randx = Item.field_77697_d.nextDouble() / 8.0;
                    double randz = Item.field_77697_d.nextDouble() / 8.0;
                    for (int i = 0; i < 2; ++i) {
                        worldIn.func_175688_a(EnumParticleTypes.CLOUD, originx + lookx, y + looky, originz + lookz, partx + randx, 0.25, partz + randz, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.ITEM_CRACK, originx + lookx, y + looky, originz + lookz, partx + randx, 0.25, partz + randz, new int[]{Item.func_150891_b((Item)itemstack.func_77973_b()), itemstack.func_77960_j()});
                    }
                }
                itemstack.func_77972_a(1, (EntityLivingBase)playerIn);
            }
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    private NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    private String getSelectedDungeon(ItemStack stack) {
        String blockname = this.getNBT(stack).func_74779_i("dungeon");
        if (blockname.isEmpty()) {
            return "Runestone";
        }
        return blockname;
    }

    private boolean setSelectedDungeon(ItemStack stack, String dungeon) {
        NBTTagCompound nbt = this.getNBT(stack);
        if (dungeon == null) {
            nbt.func_74778_a("dungeon", "Runestone");
            return true;
        }
        if (dungeon != this.getSelectedDungeon(stack)) {
            nbt.func_74778_a("dungeon", dungeon);
            return true;
        }
        return false;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.getSelectedDungeon(stack) != null) {
            tooltip.add(TextFormatting.AQUA + "[" + this.getSelectedDungeon(stack) + "]" + TextFormatting.RESET);
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"string.theaurorian.tooltip.shiftinfo", (Object[])new Object[0]) + TextFormatting.RESET);
        } else {
            tooltip.add(I18n.func_135052_a((String)"string.theaurorian.tooltip.locator", (Object[])new Object[0]));
        }
    }
}

