/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Util;

import com.elseytd.theaurorian.TAConfig;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AurorianSteelHelper {
    public static int maxlevelbase = TAConfig.Config_AurorianSteel_BaseMaxLevel;
    public static float maxlevelmultiplier = TAConfig.Config_AurorianSteel_BaseMaxLevelMultiplier;

    @SideOnly(value=Side.CLIENT)
    public static String getAurorianSteelTooltip() {
        return I18n.func_135052_a((String)"string.theaurorian.tooltip.auroriansteeltools", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public static void getAurorianSteelInfo(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean canlevelup = AurorianSteelHelper.hasEnchantToLevelUp(stack, worldIn);
        if (!GuiScreen.func_146272_n()) {
            if (!canlevelup) {
                tooltip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"string.theaurorian.tooltip.auroriansteeltools.noenchants", (Object[])new Object[0]) + TextFormatting.RESET);
            } else {
                tooltip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"string.theaurorian.tooltip.silentwoodpickaxe1", (Object[])new Object[0]) + " [" + AurorianSteelHelper.getLevel(stack) + "/" + Math.round((float)maxlevelbase * AurorianSteelHelper.getMultiplier(stack)) + "]" + TextFormatting.RESET);
            }
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"string.theaurorian.tooltip.shiftinfo", (Object[])new Object[0]) + TextFormatting.RESET);
        } else {
            String nextenchant;
            if (canlevelup && (nextenchant = AurorianSteelHelper.getNextEnchantment(stack, worldIn)) != null) {
                tooltip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"string.theaurorian.tooltip.auroriansteeltools.nextenchant", (Object[])new Object[0]) + nextenchant + TextFormatting.RESET);
            }
            tooltip.add(AurorianSteelHelper.getAurorianSteelTooltip());
        }
    }

    public static String getNextEnchantment(ItemStack stack, World worldIn) {
        if (stack.func_77948_v()) {
            Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
            block4: for (Map.Entry e : enchs.entrySet()) {
                if (((Enchantment)e.getKey()).func_77325_b() <= 1 || (Integer)e.getValue() >= ((Enchantment)e.getKey()).func_77325_b()) continue;
                switch (TAConfig.Config_AurorianSteel_Enchants_WhitelistBlacklist) {
                    default: {
                        return ((Enchantment)e.getKey()).func_77316_c((Integer)e.getValue() + 1);
                    }
                    case 1: {
                        for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                            if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                            return ((Enchantment)e.getKey()).func_77316_c((Integer)e.getValue() + 1);
                        }
                        continue block4;
                    }
                    case 2: {
                        for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                            if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                            return null;
                        }
                        return ((Enchantment)e.getKey()).func_77316_c((Integer)e.getValue() + 1);
                    }
                }
            }
        }
        return null;
    }

    public static boolean hasEnchantToLevelUp(ItemStack stack, World worldIn) {
        if (stack.func_77948_v()) {
            Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
            block4: for (Map.Entry e : enchs.entrySet()) {
                if (((Enchantment)e.getKey()).func_77325_b() <= 1 || (Integer)e.getValue() >= ((Enchantment)e.getKey()).func_77325_b()) continue;
                switch (TAConfig.Config_AurorianSteel_Enchants_WhitelistBlacklist) {
                    default: {
                        return true;
                    }
                    case 1: {
                        for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                            if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                            return true;
                        }
                        continue block4;
                    }
                    case 2: {
                        for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                            if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void handleAurorianSteelDurability(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        float levelmultiplier;
        int itemlevel = AurorianSteelHelper.getLevel(stack);
        if (itemlevel >= Math.round((float)maxlevelbase * (levelmultiplier = AurorianSteelHelper.getMultiplier(stack))) - 1) {
            if (stack.func_77948_v()) {
                Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
                block4: for (Map.Entry e : enchs.entrySet()) {
                    if (((Enchantment)e.getKey()).func_77325_b() <= 1 || (Integer)e.getValue() >= ((Enchantment)e.getKey()).func_77325_b()) continue;
                    switch (TAConfig.Config_AurorianSteel_Enchants_WhitelistBlacklist) {
                        default: {
                            enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                            EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                            AurorianSteelHelper.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                            AurorianSteelHelper.setLevel(stack, 0);
                            return;
                        }
                        case 1: {
                            for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                                if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                                enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                                EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                                AurorianSteelHelper.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                                AurorianSteelHelper.setLevel(stack, 0);
                                return;
                            }
                            continue block4;
                        }
                        case 2: {
                            for (String enchreg : TAConfig.Config_AurorianSteel_Enchants) {
                                if (!enchreg.equals(((Enchantment)e.getKey()).getRegistryName().toString()) && !((Enchantment)e.getKey()).getRegistryName().func_110624_b().equals(enchreg)) continue;
                                return;
                            }
                            enchs.put(e.getKey(), (Integer)e.getValue() + 1);
                            EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
                            AurorianSteelHelper.setMultiplier(stack, levelmultiplier * maxlevelmultiplier);
                            AurorianSteelHelper.setLevel(stack, 0);
                            return;
                        }
                    }
                }
            }
        } else {
            AurorianSteelHelper.setLevel(stack, itemlevel + 1);
        }
    }

    public static float getMultiplier(ItemStack stack) {
        AurorianSteelHelper.checkNbt(stack);
        return stack.func_77978_p().func_74760_g("upgrademultiplier");
    }

    public static void setMultiplier(ItemStack stack, float amt) {
        NBTTagCompound nbt = AurorianSteelHelper.checkNbt(stack);
        nbt.func_74776_a("upgrademultiplier", amt);
    }

    public static int getLevel(ItemStack stack) {
        AurorianSteelHelper.checkNbt(stack);
        return stack.func_77978_p().func_74762_e("currentupgradelevel");
    }

    public static void setLevel(ItemStack stack, int amt) {
        NBTTagCompound nbt = AurorianSteelHelper.checkNbt(stack);
        nbt.func_74768_a("currentupgradelevel", amt);
    }

    public static NBTTagCompound checkNbt(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (!nbt.func_74764_b("currentupgradelevel")) {
            nbt.func_74768_a("currentupgradelevel", 0);
            stack.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b("upgrademultiplier")) {
            nbt.func_74776_a("upgrademultiplier", 1.0f);
            stack.func_77982_d(nbt);
        }
        return nbt;
    }
}

