/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Structures;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.Util.GenerationHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_Runestone_Tower
extends WorldGenerator
implements GenerationHelper.IChunkSpecific {
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLELOW = new ResourceLocation("theaurorian", "chests/runestonetowerlow");
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLEMED = new ResourceLocation("theaurorian", "chests/runestonetowermed");
    private static final ResourceLocation RUNESTONETOWER_LOOTTABLEHIGH = new ResourceLocation("theaurorian", "chests/runestonetowerhigh");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_tl");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_tr");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_bl");
    private static final ResourceLocation RUNESTONETOWER_TERRAIN_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_terrain_br");
    private static final ResourceLocation RUNESTONETOWER_BASE_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_tlv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_trv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_blv2");
    private static final ResourceLocation RUNESTONETOWER_BASE_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_base_brv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_tlv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_trv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_blv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_brv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_tlv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_trv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_blv2");
    private static final ResourceLocation RUNESTONETOWER_FLOOR2_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_floor_2_brv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_TL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_tlv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_TR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_trv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_BL = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_blv2");
    private static final ResourceLocation RUNESTONETOWER_TOP_BR = new ResourceLocation("theaurorian", "runestonedungeon/runestonetower_top_brv2");
    public static int FLOOR_COUNT = TAConfig.Config_RunestoneDungeonFloors;
    public static int CHUNKS_BETWEEN_TOWERS = TAConfig.Config_DungeonDensity;
    public static boolean GENERATE_TOWERS = TAConfig.Config_GenerateRunestoneDungeon;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.generateTower(worldIn, worldIn.func_175726_f(position), rand);
        return true;
    }

    @Override
    public boolean isValidChunkForGen(int chunkX, int chunkZ, int offsetX, int offsetZ) {
        return (chunkX + offsetX) % CHUNKS_BETWEEN_TOWERS == 0 && (chunkZ + offsetZ) % CHUNKS_BETWEEN_TOWERS == 0;
    }

    private int getDungeonBaseHeight(World world, int x, int z, int part) {
        int x1 = x;
        int i = world.func_72800_K();
        int z1 = z;
        switch (part) {
            case 1: {
                x1 += 30;
                break;
            }
            case 2: {
                x1 += 30;
                z1 += 17;
                break;
            }
            case 3: {
                x1 += 15;
                break;
            }
            case 4: {
                x1 += 15;
                z1 += 15;
            }
        }
        Block blk = world.func_180495_p(new BlockPos(x1, i, z1)).func_177230_c();
        while (blk == Blocks.field_150350_a || blk == TABlocks.Registry.SILENTWOODLEAVES.getBlock() || blk == TABlocks.Registry.SILENTWOODLOG.getBlock() || blk instanceof BlockBush && i > 0) {
            blk = world.func_180495_p(new BlockPos(x1, --i, z1)).func_177230_c();
        }
        return i + 1;
    }

    private void generateTower(World world, Chunk c, Random r) {
        if (FLOOR_COUNT % 2 != 0) {
            ++FLOOR_COUNT;
        }
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 86;
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        PlacementSettings settingsrotated = new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        Template floor_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR_TL);
        Template floor_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR_BR);
        Template floor_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR_TR);
        Template floor_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR_BL);
        Template floor2_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR2_TL);
        Template floor2_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR2_BR);
        Template floor2_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR2_TR);
        Template floor2_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_FLOOR2_BL);
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -1)) {
            Template terrain_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TERRAIN_TL);
            Template base_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_BASE_TL);
            Template top_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_TL);
            Template top_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_BR);
            for (int i = y = this.getDungeonBaseHeight(world, x + 1, z, 1); i >= 50; --i) {
                terrain_tl.func_186253_b(world, new BlockPos(x + 1, i - 1, z), settings);
            }
            base_tl.func_186253_b(world, new BlockPos(x + 1, y, z), settings);
            GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, y, z), base_tl, settings, "chest", RUNESTONETOWER_LOOTTABLELOW);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_tl.func_186253_b(world, new BlockPos(x + 1, y + 6 * floor, z), settings);
                    GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, y + 6 * floor, z), floor_tl, settings, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_br.func_186253_b(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 14), floor2_br, settingsrotated, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_tl.func_186253_b(world, new BlockPos(x + 1, bossfloorlevel, z), settings);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, bossfloorlevel, z), top_tl, settings, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            } else {
                top_br.func_186253_b(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 14), top_br, settingsrotated, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            }
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            Template terrain_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_TERRAIN_TR);
            Template base_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_BASE_TR);
            Template top_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_TR);
            Template top_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_BL);
            for (int i = y = this.getDungeonBaseHeight(world, x + 1, z - 1, 2); i >= 50; --i) {
                terrain_tr.func_186253_b(world, new BlockPos(x + 1, i - 1, z + 1), settings);
            }
            base_tr.func_186253_b(world, new BlockPos(x + 1, y, z + 1), settings);
            GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, y, z + 1), base_tr, settings, "chest", RUNESTONETOWER_LOOTTABLELOW);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_tr.func_186253_b(world, new BlockPos(x + 1, y + 6 * floor, z + 1), settings);
                    GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, y + 6 * floor, z + 1), floor_tr, settings, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_bl.func_186253_b(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 1 + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1 + 14, y + 6 * floor, z + 1 + 14), floor2_bl, settingsrotated, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_tr.func_186253_b(world, new BlockPos(x + 1, bossfloorlevel, z + 1), settings);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1, bossfloorlevel, z + 1), top_tr, settings, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            } else {
                top_bl.func_186253_b(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 1 + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 1 + 14, bossfloorlevel, z + 1 + 14), top_bl, settingsrotated, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            }
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 0, -1)) {
            Template terrain_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TERRAIN_BL);
            Template base_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_BASE_BL);
            Template top_bl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_BL);
            Template top_tr = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_TR);
            for (int i = y = this.getDungeonBaseHeight(world, x, z, 3); i >= 50; --i) {
                terrain_bl.func_186253_b(world, new BlockPos(x, i - 1, z), settings);
            }
            base_bl.func_186253_b(world, new BlockPos(x, y, z), settings);
            GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, y, z), base_bl, settings, "chest", RUNESTONETOWER_LOOTTABLELOW);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_bl.func_186253_b(world, new BlockPos(x, y + 6 * floor, z), settings);
                    GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, y + 6 * floor, z), floor_bl, settings, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_tr.func_186253_b(world, new BlockPos(x + 14, y + 6 * floor, z + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 14, y + 6 * floor, z + 14), floor2_tr, settingsrotated, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_bl.func_186253_b(world, new BlockPos(x, bossfloorlevel, z), settings);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, bossfloorlevel, z), top_bl, settings, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            } else {
                top_tr.func_186253_b(world, new BlockPos(x + 14, bossfloorlevel, z + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 14, bossfloorlevel, z + 14), top_tr, settingsrotated, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            }
        } else if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            Template terrain_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_TERRAIN_BR);
            Template base_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_BASE_BR);
            Template top_br = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_BR);
            Template top_tl = GenerationHelper.getTemplate(world, RUNESTONETOWER_TOP_TL);
            for (int i = y = this.getDungeonBaseHeight(world, x, z + 1, 4); i >= 50; --i) {
                terrain_br.func_186253_b(world, new BlockPos(x, i, z + 1), settings);
            }
            base_br.func_186253_b(world, new BlockPos(x, y, z + 1), settings);
            GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, y, z + 1), base_br, settings, "chest", RUNESTONETOWER_LOOTTABLELOW);
            boolean alt = true;
            int floor = 1;
            while (floor <= FLOOR_COUNT) {
                if (alt) {
                    floor_br.func_186253_b(world, new BlockPos(x, y + 6 * floor, z + 1), settings);
                    GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, y + 6 * floor, z + 1), floor_br, settings, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                    ++floor;
                    alt = !alt;
                    continue;
                }
                floor2_tl.func_186253_b(world, new BlockPos(x + 14, y + 6 * floor, z + 1 + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 14, y + 6 * floor, z + 1 + 14), floor2_tl, settingsrotated, "chest", floor < FLOOR_COUNT / 2 ? RUNESTONETOWER_LOOTTABLELOW : RUNESTONETOWER_LOOTTABLEMED);
                ++floor;
                ++floor;
                alt = !alt;
            }
            int bossfloorlevel = y + 6 * floor;
            if (alt) {
                top_br.func_186253_b(world, new BlockPos(x, bossfloorlevel, z + 1), settings);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, bossfloorlevel, z + 1), top_br, settings, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            } else {
                top_tl.func_186253_b(world, new BlockPos(x + 14, bossfloorlevel, z + 1 + 14), settingsrotated);
                GenerationHelper.populateChestsInTemplate(world, new BlockPos(x + 14, bossfloorlevel, z + 1 + 14), top_tl, settingsrotated, "chest", RUNESTONETOWER_LOOTTABLEHIGH);
            }
        }
    }
}

