/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World;

import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_DarkstoneDungeon;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_Graveyard;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_MoonTemple;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_Ruins;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_Runestone_Tower;
import com.elseytd.theaurorian.World.Structures.TAWorldGenerator_UmbraTower;
import com.elseytd.theaurorian.World.TATerrainGenerator;
import com.fluke.worleycaves.world.WorleyCaveGenerator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class TAChunkGenerator
implements IChunkGenerator {
    private final World worldObj;
    private Random random;
    private Biome[] biomes;
    private MapGenBase caveGenerator = new WorleyCaveGenerator();
    private TATerrainGenerator terraingen = new TATerrainGenerator();
    private TAWorldGenerator_Runestone_Tower towergen = new TAWorldGenerator_Runestone_Tower();
    private TAWorldGenerator_Ruins ruingen = new TAWorldGenerator_Ruins();
    private TAWorldGenerator_MoonTemple templegen = new TAWorldGenerator_MoonTemple();
    private TAWorldGenerator_UmbraTower umbratowergen = new TAWorldGenerator_UmbraTower();
    private TAWorldGenerator_DarkstoneDungeon darkstonegen = new TAWorldGenerator_DarkstoneDungeon();
    private TAWorldGenerator_Graveyard graveyardgen = new TAWorldGenerator_Graveyard();

    public TAChunkGenerator(World worldObj) {
        this.worldObj = worldObj;
        long seed = worldObj.func_72905_C();
        this.random = new Random((seed + 516L) * 314L);
        this.terraingen.setup(worldObj, this.random);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomes = this.worldObj.func_72959_q().func_76937_a(this.biomes, x * 4 - 2, z * 4 - 2, 10, 10);
        this.terraingen.setBiomes(this.biomes);
        this.terraingen.generate(x, z, chunkprimer);
        this.biomes = this.worldObj.func_72959_q().func_76933_b(this.biomes, x * 16, z * 16, 16, 16);
        this.terraingen.replaceBiomeBlocks(x, z, chunkprimer, this, this.biomes);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomes[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        if (TAWorldGenerator_Runestone_Tower.GENERATE_TOWERS) {
            this.towergen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        if (TAWorldGenerator_Ruins.GENERATE_RUINS) {
            this.ruingen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        if (TAWorldGenerator_MoonTemple.GENERATE_TEMPLES) {
            this.templegen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        if (TAWorldGenerator_UmbraTower.GENERATE_TOWERS) {
            this.umbratowergen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        if (TAWorldGenerator_Graveyard.GENERATE_GRAVEYARDS) {
            this.graveyardgen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        if (TAWorldGenerator_DarkstoneDungeon.GENERATE_DUNGEON) {
            this.darkstonegen.func_180709_b(this.worldObj, this.random, blockpos);
        }
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(0, 0, 0));
        biome.func_180624_a(this.worldObj, this.random, blockpos);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.random);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

