/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.integration.CosmeticArmorIntegration;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.slot.BeltExtensionSlot;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.PacketDistributor;

public class BeltFinderBeltSlot
extends BeltFinder {
    public static final String FINDER_ID = "belt_slot";

    @CapabilityInject(value=BeltExtensionSlot.class)
    public static void initBaubles(Capability<?> cap) {
        BeltFinder.addFinder(new BeltFinderBeltSlot());
    }

    @Override
    public String getName() {
        return FINDER_ID;
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(PlayerEntity player) {
        return BeltExtensionSlot.get((LivingEntity)player).resolve().flatMap(ext -> ext.getSlots().stream().filter(slot -> slot.getContents().func_77973_b() instanceof ToolBeltItem).map(slot -> new ExtensionSlotBeltGetter(player, (IExtensionSlot)slot)).findFirst());
    }

    @Override
    public void setToSlot(LivingEntity player, int slotNumber, ItemStack stack) {
        BeltExtensionSlot.get(player).ifPresent(slot -> slot.getBelt().setContents(stack));
    }

    private static class ExtensionSlotBeltGetter
    implements BeltFinder.BeltGetter {
        private PlayerEntity player;
        private final IExtensionSlot slot;

        private ExtensionSlotBeltGetter(PlayerEntity player, IExtensionSlot slot) {
            this.player = player;
            this.slot = slot;
        }

        @Override
        public ItemStack getBelt() {
            return this.slot.getContents();
        }

        @Override
        public boolean isHidden() {
            return ModList.get().isLoaded("cosmeticarmorreworked") && CosmeticArmorIntegration.isHidden(this.player, "toolbelt", "belt#0");
        }

        @Override
        public void syncToClients() {
            LivingEntity thePlayer = this.slot.getContainer().getOwner();
            if (thePlayer.field_70170_p.field_72995_K) {
                return;
            }
            BeltContentsChange message = new BeltContentsChange(thePlayer, BeltFinderBeltSlot.FINDER_ID, 0, this.slot.getContents());
            ToolBelt.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> thePlayer), (Object)message);
        }
    }
}

