/*
 * Decompiled with CFR 0.152.
 */
package net.matyasu.torument.world.biome;

import java.util.Random;
import java.util.Set;
import net.matyasu.torument.TorumentModElements;
import net.matyasu.torument.entity.FlyEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ObjectHolder;

@TorumentModElements.ModElement.Tag
public class FairyForestBiome
extends TorumentModElements.ModElement {
    @ObjectHolder(value="torument:fairy_forest")
    public static final CustomBiome biome = null;

    public FairyForestBiome(TorumentModElements instance) {
        super(instance, 35);
    }

    @Override
    public void initElements() {
        this.elements.biomes.add(() -> new CustomBiome());
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SAVANNA});
        BiomeManager.addSpawnBiome((Biome)biome);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)biome, 10));
    }

    static class CustomTreeFeature
    extends AbstractTreeFeature<BaseTreeFeatureConfig> {
        CustomTreeFeature() {
            super(BaseTreeFeatureConfig::func_227376_b_);
        }

        protected boolean func_225557_a_(IWorldGenerationReader worldgen, Random rand, BlockPos position, Set<BlockPos> changedBlocks, Set<BlockPos> changedBlocks2, MutableBoundingBox bbox, BaseTreeFeatureConfig conf) {
            if (!(worldgen instanceof IWorld)) {
                return false;
            }
            IWorld world = (IWorld)worldgen;
            int height = rand.nextInt(5) + 1;
            boolean spawnTree = true;
            if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= world.func_217301_I()) {
                for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                    int k = 1;
                    if (j == position.func_177956_o()) {
                        k = 0;
                    }
                    if (j >= position.func_177956_o() + height - 1) {
                        k = 2;
                    }
                    for (int px = position.func_177958_n() - k; px <= position.func_177958_n() + k && spawnTree; ++px) {
                        for (int pz = position.func_177952_p() - k; pz <= position.func_177952_p() + k && spawnTree; ++pz) {
                            if (j >= 0 && j < world.func_217301_I()) {
                                if (this.isReplaceable(world, new BlockPos(px, j, pz))) continue;
                                spawnTree = false;
                                continue;
                            }
                            spawnTree = false;
                        }
                    }
                }
                if (!spawnTree) {
                    return false;
                }
                Block ground = world.func_180495_p(position.func_177982_a(0, -1, 0)).func_177230_c();
                Block ground2 = world.func_180495_p(position.func_177982_a(0, -2, 0)).func_177230_c();
                if (ground != Blocks.field_196658_i.func_176223_P().func_177230_c() && ground != Blocks.field_150346_d.func_176223_P().func_177230_c() || ground2 != Blocks.field_196658_i.func_176223_P().func_177230_c() && ground2 != Blocks.field_150346_d.func_176223_P().func_177230_c()) {
                    return false;
                }
                BlockState state = world.func_180495_p(position.func_177977_b());
                if (position.func_177956_o() < world.func_217301_I() - height - 1) {
                    int genh;
                    this.setTreeBlockState(changedBlocks, (IWorldWriter)world, position.func_177977_b(), Blocks.field_150346_d.func_176223_P(), bbox);
                    for (genh = position.func_177956_o() - 3 + height; genh <= position.func_177956_o() + height; ++genh) {
                        int i4 = genh - (position.func_177956_o() + height);
                        int j1 = (int)(1.0 - (double)i4 * 0.5);
                        for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                            for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                                BlockPos blockpos;
                                int j2 = i2 - position.func_177952_p();
                                if (Math.abs(position.func_177958_n()) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(k1, genh, i2))).func_177230_c().isAir(state, (IBlockReader)world, blockpos) && !state.func_185904_a().func_76230_c() && !state.func_203425_a(BlockTags.field_206952_E) && state.func_177230_c() != Blocks.field_150350_a.func_176223_P().func_177230_c() && state.func_177230_c() != Blocks.field_196642_W.func_176223_P().func_177230_c()) continue;
                                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, blockpos, Blocks.field_196642_W.func_176223_P(), bbox);
                            }
                        }
                    }
                    for (genh = 0; genh < height; ++genh) {
                        BlockPos genhPos = position.func_177981_b(genh);
                        state = world.func_180495_p(genhPos);
                        this.setTreeBlockState(changedBlocks, (IWorldWriter)world, genhPos, Blocks.field_196617_K.func_176223_P(), bbox);
                        if (!state.func_177230_c().isAir(state, (IBlockReader)world, genhPos) && !state.func_185904_a().func_76230_c() && !state.func_203425_a(BlockTags.field_206952_E) && state.func_177230_c() != Blocks.field_150350_a.func_176223_P().func_177230_c() && state.func_177230_c() != Blocks.field_196642_W.func_176223_P().func_177230_c()) continue;
                    }
                    if (rand.nextInt(4) == 0 && height > 5) {
                        for (int hlevel = 0; hlevel < 2; ++hlevel) {
                            for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - hlevel) != 0) continue;
                                Direction dir = Direction2.func_176734_d();
                                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, position.func_177982_a(dir.func_82601_c(), height - 5 + hlevel, dir.func_82599_e()), Blocks.field_150350_a.func_176223_P(), bbox);
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private void addVines(IWorld world, BlockPos pos, Set<BlockPos> changedBlocks, MutableBoundingBox bbox) {
            this.setTreeBlockState(changedBlocks, (IWorldWriter)world, pos, Blocks.field_150350_a.func_176223_P(), bbox);
            BlockPos blockpos = pos.func_177977_b();
            for (int i = 5; world.func_175623_d(blockpos) && i > 0; --i) {
                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, blockpos, Blocks.field_150350_a.func_176223_P(), bbox);
                blockpos = blockpos.func_177977_b();
            }
        }

        private boolean canGrowInto(Block blockType) {
            return blockType.func_176223_P().func_185904_a() == Material.field_151579_a || blockType == Blocks.field_196617_K.func_176223_P().func_177230_c() || blockType == Blocks.field_196642_W.func_176223_P().func_177230_c() || blockType == Blocks.field_196658_i.func_176223_P().func_177230_c() || blockType == Blocks.field_150346_d.func_176223_P().func_177230_c();
        }

        private boolean isReplaceable(IWorld world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || this.canGrowInto(state.func_177230_c()) || !state.func_185904_a().func_76230_c();
        }

        private void setTreeBlockState(Set<BlockPos> changedBlocks, IWorldWriter world, BlockPos pos, BlockState state, MutableBoundingBox mbb) {
            super.func_227217_a_(world, pos, state, mbb);
            changedBlocks.add(pos.func_185334_h());
        }
    }

    static class CustomBiome
    extends Biome {
        public CustomBiome() {
            super(new Biome.Builder().func_205417_d(0.5f).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205412_a(-1926467).func_205413_b(-1926467).func_205418_a("torument:fairy_forest").func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P())));
            this.setRegistryName("fairy_forest");
            DefaultBiomeFeatures.func_222300_a((Biome)this);
            DefaultBiomeFeatures.func_222295_c((Biome)this);
            DefaultBiomeFeatures.func_222335_f((Biome)this);
            DefaultBiomeFeatures.func_222288_h((Biome)this);
            DefaultBiomeFeatures.func_222333_d((Biome)this);
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226831_z_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new CustomTreeFeature().func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P())).func_225569_d_(1).setSapling((IPlantable)Blocks.field_196678_w).func_225568_b_()).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(3, 0.1f, 1))));
            this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(FlyEntity.entity, 1, 1, 1));
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_225528_a_(double posX, double posZ) {
            return -25653;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_225527_a_() {
            return -25653;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_225529_c_() {
            return -14366;
        }
    }
}

